/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community;

import eu.dnetlib.openaire.common.AbstractExporterController;
import eu.dnetlib.openaire.community.CommunityService;
import eu.dnetlib.openaire.community.model.DepositionInfo;
import eu.dnetlib.openaire.community.utils.CommunityMappingUtils;
import eu.dnetlib.openaire.exporter.exceptions.CommunityException;
import eu.dnetlib.openaire.exporter.exceptions.ResourceNotFoundException;
import eu.dnetlib.openaire.exporter.model.community.CommunityContentprovider;
import eu.dnetlib.openaire.exporter.model.community.CommunityProject;
import eu.dnetlib.openaire.exporter.model.community.SubCommunity;
import eu.dnetlib.openaire.exporter.model.community.SubCommunityWritableProperties;
import eu.dnetlib.openaire.exporter.model.community.selectioncriteria.SelectionCriteria;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.community"}, havingValue="true")
@Tag(name="OpenAIRE Communities API", description="the OpenAIRE Community API")
public class SubCommunityApiController
extends AbstractExporterController {
    @Autowired
    private CommunityService communityService;

    @GetMapping(value={"/community/{id}/subcommunities"})
    @Operation(summary="get the list of subcommunities for a given community", description="get the list of subcommunities for a given community", tags={"Subcommunities", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<SubCommunity> getSubCommunities(@PathVariable String id, @RequestParam(required=false) String subCommunityId, @RequestParam(required=false, defaultValue="false") boolean all) throws CommunityException {
        try {
            return this.communityService.getSubCommunitiesForCommunity(id).stream().filter(sc -> subCommunityId != null ? subCommunityId.equals(sc.getSubCommunityId()) : all || sc.isBrowsable()).collect(Collectors.toList());
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunities"})
    @Operation(summary="associate a subcommunity to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a subcommunity to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity addSubCommunity(@PathVariable String id, @RequestBody SubCommunity subcommunity) throws CommunityException {
        try {
            return this.communityService.addSubCommunity(id, subcommunity);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunities/update"})
    @Operation(summary="update a subcommunity to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a subcommunity to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity updateSubCommunity(@PathVariable String id, @RequestParam String subCommunityId, @RequestBody SubCommunityWritableProperties details) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.updateSubCommunity(subCommunityId, details);
            return this.communityService.getSubCommunity(id, subCommunityId);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunitiesList"})
    @Operation(summary="associate a list of subcommunities to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a list of subcommunities to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<SubCommunity> addSubCommunityList(@PathVariable String id, @RequestBody SubCommunity[] subcommunities) throws CommunityException {
        for (SubCommunity sub : subcommunities) {
            if (id.equals(CommunityMappingUtils.calculateMainCommunityId((String)sub.getSubCommunityId()))) continue;
            throw new CommunityException("The sub-collection id does not start with " + id);
        }
        try {
            ArrayList<SubCommunity> res = new ArrayList<SubCommunity>();
            for (SubCommunity subc : subcommunities) {
                res.add(this.communityService.addSubCommunity(id, subc));
            }
            return res;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subcommunities"})
    @Operation(summary="remove the association between a subcommunity and the community", description="remove the association between a subcommunity and the community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeSubCommunity(@PathVariable String id, @RequestParam String subCommunityId) throws CommunityException {
        try {
            this.communityService.removeSubCommunity(id, subCommunityId);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subcommunitiesList"})
    @Operation(summary="remove a list of associations between some subcommunities and the community", description="remove a list of associations between some subcommunities and the community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeSubcommunities(@PathVariable String id, @RequestBody String[] subCommunityIdList) throws CommunityException {
        try {
            for (String subId : subCommunityIdList) {
                this.communityService.removeSubCommunity(id, subId);
            }
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunities/subjects"})
    @Operation(summary="associate a subject to a sub-community", description="associate a subject to a sub-community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity addSubCommunitySubjects(@PathVariable String id, @RequestParam String subCommunityId, @RequestBody String[] subjects) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.addCommunitySubjects(subCommunityId, subjects);
            return this.communityService.getSubCommunity(id, subCommunityId);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subcommunities/subjects"})
    @Operation(summary="remove subjects from a sub-community", description="remove subjects from a sub-community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity removeSubCommunitySubjects(@PathVariable String id, @RequestParam String subCommunityId, @RequestBody String[] subjects) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.removeCommunitySubjects(subCommunityId, subjects);
            return this.communityService.getSubCommunity(id, subCommunityId);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunities/fos"})
    @Operation(summary="associate a fos to a sub-community", description="associate a fos to a sub-community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity addSubCommunityFOS(@PathVariable String id, @RequestParam String subCommunityId, @RequestBody String[] subjects) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.addCommunityFOS(subCommunityId, subjects);
            return this.communityService.getSubCommunity(id, subCommunityId);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subcommunities/fos"})
    @Operation(summary="remove fos from a sub-community", description="remove fos from a sub-community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity removeSubCommunityFOS(@PathVariable String id, @RequestParam String subCommunityId, @RequestBody String[] subjects) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.removeCommunityFOS(subCommunityId, subjects);
            return this.communityService.getSubCommunity(id, subCommunityId);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunities/sdg"})
    @Operation(summary="associate a sdg to a sub-community", description="associate a sdg to the community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity addSubCommunitySDG(@PathVariable String id, @RequestParam String subCommunityId, @RequestBody String[] subjects) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.addCommunitySDG(subCommunityId, subjects);
            return this.communityService.getSubCommunity(id, subCommunityId);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subcommunities/sdg"})
    @Operation(summary="remove sdg from a sub-community", description="remove sdg from a sub-community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity removeSubCommunitySDG(@PathVariable String id, @RequestParam String subCommunityId, @RequestBody String[] subjects) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.removeCommunitySDG(subCommunityId, subjects);
            return this.communityService.getSubCommunity(id, subCommunityId);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunities/advancedConstraint"})
    @Operation(summary="the set of constraints to be used to extend the association between result and sub-community", description="the set of constraints to be used to extend the association between result and sub-community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity addASubCommunitydvancedConstraint(@PathVariable String id, @RequestParam String subCommunityId, @RequestBody SelectionCriteria advancedConstraint) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.addCommunityAdvancedConstraint(subCommunityId, advancedConstraint);
            return this.communityService.getSubCommunity(id, subCommunityId);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subcommunities/advancedConstraint"})
    @Operation(summary="remove the constraints to extend the association result community from a community", description="remove the constraints to extend the association result community from a community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity removeSubCommunityAdvancedConstraint(@PathVariable String id, @RequestParam String subCommunityId) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.removeCommunityAdvancedConstraint(subCommunityId);
            return this.communityService.getSubCommunity(id, subCommunityId);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunities/removeConstraint"})
    @Operation(summary="the set of constraints to be used to remove the association between result and sub-community", description="the set of constraints to be used to remove the association between result and sub-community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity addSubCommunityRemoveConstraint(@PathVariable String id, @RequestParam String subCommunityId, @RequestBody SelectionCriteria removeConstraint) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.addCommunityRemoveConstraint(subCommunityId, removeConstraint);
            return this.communityService.getSubCommunity(id, subCommunityId);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subcommunities/removeConstraint"})
    @Operation(summary="remove the constraints to remove the association beetween result and sub-community", description="remove the constraints to remove the association beetween result and sub-community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity removeSubCommunityRemoveConstraint(@PathVariable String id, @RequestParam String subCommunityId) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.removeCommunityRemoveConstraint(subCommunityId);
            return this.communityService.getSubCommunity(id, subCommunityId);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunities/zenodocommunities"})
    @Operation(summary="associate a Zenodo community to a sub-community", description="associate a Zenodo community to a sub-community", tags={"Community Zenodo Communities", "Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity addSubCommunityZenodoCommunity(@PathVariable String id, @RequestParam String subCommunityId, @RequestParam(required=false, defaultValue="false") boolean main, @RequestParam String zenodocommunity) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.addCommunityZenodoCommunity(subCommunityId, zenodocommunity, main);
            return this.communityService.getSubCommunity(id, subCommunityId);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subcommunities/zenodocommunities"})
    @Operation(summary="remove a Zenodo community from a sub-community", description="remove a Zenodo community from a sub-community", tags={"Community Zenodo Communities", "Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity removeSubCommunityZenodoCommunity(@PathVariable String id, @RequestParam String subCommunityId, @RequestParam(required=false, defaultValue="false") boolean main, @RequestParam String zenodocommunity) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.removeCommunityZenodoCommunity(subCommunityId, zenodocommunity, main);
            return this.communityService.getSubCommunity(id, subCommunityId);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{id}/subcommunities/projects/{page}/{size}"})
    @Operation(summary="get community projects", description="get community projects", tags={"Subcommunities", "Community projects", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Page<CommunityProject> getCommunityProjects(@PathVariable String id, @PathVariable Integer page, @PathVariable Integer size, @RequestParam String subCommunityId, @RequestParam(required=false) String funder, @RequestParam(required=false) String searchFilter, @RequestParam(required=false) String orderBy) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            return this.communityService.getCommunityProjects(subCommunityId, funder, searchFilter, page.intValue(), size.intValue(), orderBy);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunities/projects"})
    @Operation(summary="associate a project to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a project to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Subcommunities", "Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityProject addCommunityProject(@PathVariable String id, @RequestParam String subCommunityId, @RequestBody CommunityProject project) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            return this.communityService.addCommunityProject(subCommunityId, project);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subcommunities/projects"})
    @Operation(summary="remove a project from the community", description="remove a project from the community", tags={"Subcommunities", "Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunityProject(@PathVariable String id, @RequestParam String subCommunityId, @RequestParam String projectId) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.removeCommunityProjects(subCommunityId, new String[]{projectId});
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunities/projectList"})
    @Operation(summary="associate a list of project to the community", description="associate a list of project to the community", tags={"Subcommunities", "Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityProject[] addCommunityProjectList(@PathVariable String id, @RequestParam String subCommunityId, @RequestBody CommunityProject[] projects) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.addCommunityProjects(subCommunityId, projects);
            return projects;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subcommunities/projectList"})
    @Operation(summary="remove a list of projects from the community", description="remove a list of projects from the community", tags={"Subcommunities", "Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunityProjectList(@PathVariable String id, @RequestParam String subCommunityId, @RequestBody String[] projectIdList) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.removeCommunityProjects(subCommunityId, projectIdList);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{id}/subcommunities/funders"})
    @Operation(summary="get the funders of the projects of a community", description="get the funders of the projects of a community", tags={"Subcommunities", "Community projects", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<String> getCommunityFunders(@PathVariable String id, @RequestParam String subCommunityId) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            return this.communityService.getCommunityFunders(subCommunityId);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{id}/subcommunities/datasources"})
    @Operation(summary="get the list of datasources associated to a given community", description="get the list of content providers associated to a given community", tags={"Subcommunities", "Community content providers", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<CommunityContentprovider> getCommunityDatasources(@PathVariable String id, @RequestParam String subCommunityId, @RequestParam(required=false) Boolean deposit) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            return deposit == null ? this.communityService.getCommunityDatasources(subCommunityId) : this.communityService.getCommunityDatasourcesWithDeposit(subCommunityId, deposit.booleanValue());
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunities/datasources"})
    @Operation(summary="associate a datasource to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a datasource to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Subcommunities", "Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityContentprovider addCommunityDatasource(@PathVariable String id, @RequestParam String subCommunityId, @RequestBody CommunityContentprovider datasource) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.addCommunityDatasources(subCommunityId, new CommunityContentprovider[]{datasource});
            return datasource;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunities/datasources/deposit"})
    @Operation(summary="update the deposit and message filelds of a datasource associated to the community", description="update the deposit and message filelds of a datasource associated to the community", tags={"Subcommunities", "Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityContentprovider addCommunityDatasourceDeposit(@PathVariable String id, @RequestParam String subCommunityId, @RequestBody DepositionInfo info) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            return this.communityService.updateCommunityDatasourcesDeposit(subCommunityId, info.getOpenaireId(), info.getDeposit(), info.getMessage());
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subcommunities/datasources"})
    @Operation(summary="remove the association between a datasource and the community", description="remove the association between a datasource and the community", tags={"Subcommunities", "Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeCommunityDatasource(@PathVariable String id, @RequestParam String subCommunityId, @RequestParam String dsId) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.removeCommunityDatasources(subCommunityId, new String[]{dsId});
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunities/datasourcesList"})
    @Operation(summary="associate a list of datasources to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a list of datasources to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Subcommunities", "Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityContentprovider[] addCommunityDatasourcesList(@PathVariable String id, @RequestParam String subCommunityId, @RequestBody CommunityContentprovider[] dsList) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.addCommunityDatasources(subCommunityId, dsList);
            return dsList;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subcommunities/datasourcesList"})
    @Operation(summary="remove a list of datasources from the community", description="remove a list of datasources from the community", tags={"Subcommunities", "Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunityDatasourcesList(@PathVariable String id, @RequestParam String subCommunityId, @RequestBody String[] dsIdList) throws CommunityException {
        this.verifyIdParameters(id, subCommunityId);
        try {
            this.communityService.removeCommunityDatasources(subCommunityId, dsIdList);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{id}/subcommunities/propagationOrganizations"})
    @Operation(summary="return the propagation organizations of a sub-community", description="try { return the propagation organizations of a community", tags={"Subcommunities", "Community Organizations", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Set<String> getPropagationOrganizationsForCommunity(@PathVariable String id, @RequestParam String subCommunityId) throws CommunityException {
        try {
            return this.communityService.getPropagationOrganizationsForCommunity(subCommunityId);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunities/propagationOrganizations"})
    @Operation(summary="add an organization to the propagationOrganizationCommunityMap of a sub-community", description="add an organization to the propagationOrganizationCommunityMap", tags={"Subcommunities", "Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Set<String> addPropagationOrganizationForCommunity(@PathVariable String id, @RequestParam String subCommunityId, @RequestParam String organizationId) throws CommunityException {
        try {
            return this.communityService.addPropagationOrganizationForCommunity(subCommunityId, organizationId.split(","));
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subcommunities/propagationOrganizations"})
    @Operation(summary="delete an organization to the propagationOrganizationCommunityMap", description="delete an organization from the propagationOrganizationCommunityMap of a sub-community", tags={"Subcommunities", "Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Set<String> removePropagationOrganizationForCommunity(@PathVariable String id, @RequestParam String subCommunityId, @RequestParam String organizationId) throws CommunityException {
        try {
            return this.communityService.removePropagationOrganizationForCommunity(subCommunityId, organizationId.split(","));
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    private void verifyIdParameters(String id, String subCommunityId) throws CommunityException {
        if (!CommunityMappingUtils.isValidCommunityId((String)id)) {
            throw new CommunityException("Invalid community id: " + id);
        }
        if (!CommunityMappingUtils.isValidSubCommunityId((String)subCommunityId)) {
            throw new CommunityException("Invalid sub-collection id: " + subCommunityId);
        }
        if (!id.equals(CommunityMappingUtils.calculateMainCommunityId((String)subCommunityId))) {
            throw new CommunityException("The sub-collection id does not start with " + id);
        }
    }
}

