/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.model.community;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import eu.dnetlib.openaire.exporter.model.community.CommunityDetails;
import eu.dnetlib.openaire.exporter.model.community.CommunityStatus;
import eu.dnetlib.openaire.exporter.model.community.selectioncriteria.SelectionCriteria;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@JsonAutoDetect
public class CommunityWritableProperties {
    @Schema(description="community name")
    private String name;
    @Schema(description="community short name")
    private String shortName;
    @Schema(description="community description")
    private String description;
    @Schema(description="http url for the community logo")
    private String logoUrl;
    @Schema(description="list of subjects (keywords) that characterise this community")
    private List<String> subjects;
    @Schema(description="list of fos that characterise this community")
    private List<String> fos;
    @Schema(description="list of sdg that characterise this community")
    private List<String> sdg;
    @Schema(description="Advanced constraint for the association of results to the community")
    private SelectionCriteria advancedConstraints;
    @Schema(description="status of the community, drives its visibility")
    private CommunityStatus status;
    @Schema(description="id of the main Zenodo community")
    private String mainZenodoCommunity;

    public static CommunityWritableProperties fromDetails(CommunityDetails details) {
        CommunityWritableProperties p = new CommunityWritableProperties();
        p.setName(details.getName());
        p.setShortName(details.getShortName());
        p.setDescription(details.getDescription());
        p.setLogoUrl(details.getLogoUrl());
        p.setSubjects(details.getSubjects());
        p.setStatus(details.getStatus());
        p.setMainZenodoCommunity(details.getZenodoCommunity());
        p.setFos(details.getFos());
        p.setSdg(details.getSdg());
        p.setAdvancedConstraints(details.getAdvancedConstraints());
        return p;
    }

    public List<String> getFos() {
        return this.fos;
    }

    public void setFos(List<String> fos) {
        this.fos = fos;
    }

    public List<String> getSdg() {
        return this.sdg;
    }

    public void setSdg(List<String> sdg) {
        this.sdg = sdg;
    }

    public SelectionCriteria getAdvancedConstraints() {
        return this.advancedConstraints;
    }

    public void setAdvancedConstraints(SelectionCriteria advancedConstraints) {
        this.advancedConstraints = advancedConstraints;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<String> subjects) {
        this.subjects = subjects;
    }

    public CommunityStatus getStatus() {
        return this.status;
    }

    public void setStatus(CommunityStatus status) {
        this.status = status;
    }

    public String getMainZenodoCommunity() {
        return this.mainZenodoCommunity;
    }

    public void setMainZenodoCommunity(String mainZenodoCommunity) {
        this.mainZenodoCommunity = mainZenodoCommunity;
    }
}

