package eu.dnetlib.openaire.exporter.model.community;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonAutoDetect;

import io.swagger.v3.oas.annotations.media.Schema;

@JsonAutoDetect
public class CommunitySummary {

	@Schema(description = "identifies the community")
	protected String id;

	@Schema(description = "values for this field reflect the index field _community_ in the index, e.g. 'egi||EGI Federation'")
	protected String queryId;

	@Schema(description = "community type")
	protected String type;

	@Schema(description = "community name")
	protected String name;

	@Schema(description = "community short name")
	protected String shortName;

	@Schema(description = "community creation date")
	protected Date creationDate;

	@Schema(description = "community last update date")
	protected Date lastUpdateDate;

	@Schema(description = "community description")
	protected String description;

	@Schema(description = "http url for the community logo")
	protected String logoUrl;

	@Schema(description = "status of the community, drives its visibility")
	protected CommunityStatus status;

	@Schema(description = "Zenodo community associated to this community")
	protected String zenodoCommunity;

	public CommunitySummary() {}

	public CommunitySummary(
		final String id,
		final String queryId,
		final String type,
		final String name,
		final String shortName,
		final Date creationDate,
		final Date lastUpdateDate,
		final String description,
		final String logoUrl,
		final CommunityStatus status,
		final String zenodoCommunity) {
		this.id = id;
		this.queryId = queryId;
		this.type = type;
		this.name = name;
		this.shortName = shortName;
		this.creationDate = creationDate;
		this.lastUpdateDate = lastUpdateDate;
		this.description = description;
		this.logoUrl = logoUrl;
		this.status = status;
		this.zenodoCommunity = zenodoCommunity;
	}

	public CommunitySummary(final CommunitySummary summary) {
		this(summary.getId(),
			summary.getQueryId(),
			summary.getType(),
			summary.getName(),
			summary.getShortName(),
			summary.getCreationDate(),
			summary.getLastUpdateDate(),
			summary.getDescription(),
			summary.getLogoUrl(),
			summary.getStatus(),
			summary.getZenodoCommunity());
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getQueryId() {
		return queryId;
	}

	public void setQueryId(final String queryId) {
		this.queryId = queryId;
	}

	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(final String shortName) {
		this.shortName = shortName;
	}

	public Date getCreationDate() {
		return creationDate;
	}

	public void setCreationDate(final Date creationDate) {
		this.creationDate = creationDate;
	}

	public Date getLastUpdateDate() {
		return lastUpdateDate;
	}

	public void setLastUpdateDate(final Date lastUpdateDate) {
		this.lastUpdateDate = lastUpdateDate;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(final String description) {
		this.description = description;
	}

	public String getLogoUrl() {
		return logoUrl;
	}

	public void setLogoUrl(final String logoUrl) {
		this.logoUrl = logoUrl;
	}

	public CommunityStatus getStatus() {
		return status;
	}

	public void setStatus(final CommunityStatus status) {
		this.status = status;
	}

	public String getZenodoCommunity() {
		return zenodoCommunity;
	}

	public void setZenodoCommunity(final String zenodoCommunity) {
		this.zenodoCommunity = zenodoCommunity;
	}

}
