/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.model.community;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.openaire.exporter.model.community.selectioncriteria.SelectionCriteria;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotNull;

@JsonAutoDetect
public class CommunityDatasource {
    @Schema(description="OpenAIRE identifier for this content provider, if available", required=false)
    private String openaireId;
    @Schema(description="content provider name", required=false)
    private String name;
    @NotNull
    @Schema(description="content provider official name", required=true)
    private String officialname;
    @Schema(description="content provider enabled for content inclusion", required=false)
    private boolean enabled;
    @Schema(description="content provider selection criteria", required=false)
    private SelectionCriteria selectioncriteria;
    @Schema(description="suggested for deposition", required=false)
    private Boolean deposit;
    @Schema(description="message for the deposition page", required=false)
    private String message;

    public String getOpenaireId() {
        return this.openaireId;
    }

    public void setOpenaireId(String openaireId) {
        this.openaireId = openaireId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOfficialname() {
        return this.officialname;
    }

    public void setOfficialname(String officialname) {
        this.officialname = officialname;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public SelectionCriteria getSelectioncriteria() {
        return this.selectioncriteria;
    }

    public void setSelectioncriteria(SelectionCriteria selectioncriteria) {
        this.selectioncriteria = selectioncriteria;
    }

    public String toJson() {
        if (this.selectioncriteria == null) {
            return "";
        }
        try {
            return new ObjectMapper().writeValueAsString((Object)this.selectioncriteria);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toXML() {
        if (this.selectioncriteria == null) {
            return "";
        }
        return "<![CDATA[" + this.toJson() + "]]>";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CommunityDatasource [\n\topenaireId = ").append(this.openaireId).append(",\n\tname = ").append(this.name).append(",\n\tofficialname = ").append(this.officialname).append(",\n\tselectioncriteria = ").append(this.selectioncriteria).append("\n]");
        return builder.toString();
    }

    public Boolean getDeposit() {
        return this.deposit;
    }

    public void setDeposit(Boolean deposit) {
        this.deposit = deposit;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

