package eu.dnetlib.openaire.exporter.model.community;

import java.util.Objects;

import javax.validation.constraints.NotNull;

import io.swagger.v3.oas.annotations.media.Schema;

public class CommunityPropagationOrganization {

	@NotNull
	@Schema(description = "the organization identifier", required = true)
	private String orgId;

	@Schema(description = "a description of the organization", required = false)
	private String description;

	@Schema(description = "the organization is subscribed", required = false, defaultValue = "false")
	private boolean subscribed;

	public String getOrgId() {
		return orgId;
	}

	public void setOrgId(final String orgId) {
		this.orgId = orgId;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(final String description) {
		this.description = description;
	}

	public boolean isSubscribed() {
		return subscribed;
	}

	public void setSubscribed(final boolean subscribed) {
		this.subscribed = subscribed;
	}

	@Override
	public String toString() {
		return new StringBuilder()
				.append("CommunityPropagationOrganization [orgId=")
				.append(orgId)
				.append(", description=")
				.append(description)
				.append(", subscribed=")
				.append(subscribed)
				.append("]")
				.toString();
	}

	@Override
	public int hashCode() {
		return Objects.hash(orgId);
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) { return true; }
		if ((obj == null) || (getClass() != obj.getClass())) { return false; }
		final CommunityPropagationOrganization other = (CommunityPropagationOrganization) obj;
		return Objects.equals(orgId, other.orgId);
	}

}
