package eu.dnetlib.organizations.controller;

import java.util.LinkedHashMap;
import java.util.Map;

import eu.dnetlib.organizations.model.view.SuggestionInfoViewByCountry;

public class SuggestionInfo {

	public class SuggestionCounter {

		private long nDuplicates = 0;

		private long nConflicts = 0;

		public long getnDuplicates() {
			return nDuplicates;
		}

		public void setnDuplicates(final long nDuplicates) {
			this.nDuplicates = nDuplicates;
		}

		public long getnConflicts() {
			return nConflicts;
		}

		public void setnConflicts(final long nConflicts) {
			this.nConflicts = nConflicts;
		}

		public void add(final SuggestionInfoViewByCountry infoCountry) {
			nDuplicates += infoCountry.getnDuplicates();
			nConflicts += infoCountry.getnConflicts();
		}
	}

	public SuggestionCounter total = new SuggestionCounter();;

	public Map<String, SuggestionCounter> byCountry = new LinkedHashMap<>();

	public void add(final SuggestionInfoViewByCountry infoCountry) {
		final String country = infoCountry.getCountry();

		if (!byCountry.containsKey(country)) {
			byCountry.put(country, new SuggestionCounter());

		}
		byCountry.get(country).add(infoCountry);
		total.add(infoCountry);
	}

}
