package eu.dnetlib.organizations.model.utils;

import java.util.Objects;

public class OrganizationConflictImpl implements OrganizationConflict, Comparable<OrganizationConflict> {

	private String id;
	private String name;
	private String type;
	private String city;
	private String country;

	public OrganizationConflictImpl() {}

	public OrganizationConflictImpl(final String id) {
		this.id = id;
	}

	public OrganizationConflictImpl(final String id, final String name, final String type, final String city, final String country) {
		this.id = id;
		this.name = name;
		this.type = type;
		this.city = city;
		this.country = country;
	}

	@Override
	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	@Override
	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	@Override
	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	@Override
	public String getCity() {
		return city;
	}

	public void setCity(final String city) {
		this.city = city;
	}

	@Override
	public String getCountry() {
		return country;
	}

	public void setCountry(final String country) {
		this.country = country;
	}

	@Override
	public int compareTo(final OrganizationConflict o) {
		return getId().compareTo(o.getId());
	}

	@Override
	public int hashCode() {
		return Objects.hash(id);
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) { return true; }
		if (obj == null) { return false; }
		if (!(obj instanceof OrganizationConflictImpl)) { return false; }
		final OrganizationConflictImpl other = (OrganizationConflictImpl) obj;
		return Objects.equals(id, other.id);
	}

}
