package eu.dnetlib.organizations.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import eu.dnetlib.organizations.utils.DatabaseUtils;
import eu.dnetlib.organizations.utils.DatabaseUtils.VocabularyTable;
import eu.dnetlib.organizations.utils.RelationType;
import eu.dnetlib.organizations.utils.SimilarityType;

@RestController
public class VocabulariesController {

	@Autowired
	private DatabaseUtils databaseUtils;

	@GetMapping("/api/vocabularies")
	public Map<String, List<String>> ListVocabularies(final Authentication authentication) {
		final Map<String, List<String>> vocs = new HashMap<>();
		vocs.put("orgTypes", databaseUtils.listValuesOfVocabularyTable(VocabularyTable.org_types));
		vocs.put("idTypes", databaseUtils.listValuesOfVocabularyTable(VocabularyTable.id_types));
		vocs.put("languages", databaseUtils.listValuesOfVocabularyTable(VocabularyTable.languages));

		vocs.put("relTypes", Arrays.stream(RelationType.values()).map(Object::toString).collect(Collectors.toList()));
		vocs.put("similaritiesType", Arrays.stream(SimilarityType.values()).map(Object::toString).collect(Collectors.toList()));

		if (UserInfo.isSimpleUser(authentication) || UserInfo.isNationalAdmin(authentication)) {
			vocs.put("countries", databaseUtils.listCountriesForUser(authentication.getName()));
		} else if (UserInfo.isSuperAdmin(authentication)) {
			vocs.put("countries", databaseUtils.listValuesOfVocabularyTable(VocabularyTable.countries));
		} else {
			vocs.put("countries", new ArrayList<String>());
		}

		return vocs;
	}

	@GetMapping({ "/api/voc/allCountries", "/registration_api/voc/allCountries" })
	public List<String> allCountries() {
		return databaseUtils.listValuesOfVocabularyTable(VocabularyTable.countries);
	}

}
