package eu.dnetlib.organizations.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

@Entity
@Table(name = "oa_duplicates")
@IdClass(OpenaireDuplicatePK.class)
public class OpenaireDuplicate implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = -5656204073481770618L;

	@Id
	@Column(name = "local_id")
	private String localId;

	@Id
	@Column(name = "oa_original_id")
	private String oaOriginalId;

	@Column(name = "oa_name")
	private String oaName;

	@Column(name = "oa_acronym")
	private String oaAcronym;

	@Column(name = "oa_country")
	private String oaCountry;

	@Column(name = "oa_url")
	private String oaUrl;

	@Column(name = "oa_collectedfrom")
	private String oaCollectedFrom;

	@Column(name = "reltype")
	private String relType;

	public String getLocalId() {
		return localId;
	}

	public void setLocalId(final String localId) {
		this.localId = localId;
	}

	public String getOaOriginalId() {
		return oaOriginalId;
	}

	public void setOaOriginalId(final String oaOriginalId) {
		this.oaOriginalId = oaOriginalId;
	}

	public String getOaName() {
		return oaName;
	}

	public void setOaName(final String oaName) {
		this.oaName = oaName;
	}

	public String getOaAcronym() {
		return oaAcronym;
	}

	public void setOaAcronym(final String oaAcronym) {
		this.oaAcronym = oaAcronym;
	}

	public String getOaCountry() {
		return oaCountry;
	}

	public void setOaCountry(final String oaCountry) {
		this.oaCountry = oaCountry;
	}

	public String getOaUrl() {
		return oaUrl;
	}

	public void setOaUrl(final String oaUrl) {
		this.oaUrl = oaUrl;
	}

	public String getOaCollectedFrom() {
		return oaCollectedFrom;
	}

	public void setOaCollectedFrom(final String oaCollectedFrom) {
		this.oaCollectedFrom = oaCollectedFrom;
	}

	public String getRelType() {
		return relType;
	}

	public void setRelType(final String relType) {
		this.relType = relType;
	}

}
