package eu.dnetlib.organizations.repository.readonly;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import eu.dnetlib.organizations.model.view.OrganizationSimpleView;

@Repository
public interface OrganizationSimpleViewRepository extends ReadOnlyRepository<OrganizationSimpleView, String> {

	// SEARCH
	Page<OrganizationSimpleView> findByNameContainingIgnoreCase(String name, Pageable pageable);

	// SEARCH FOR USER
	@Query(value = "select o.* from organizations_simple_view o left outer join user_countries uc on (uc.country = o.country) where o.name ilike %:text% and uc.email = :email", nativeQuery = true)
	Page<OrganizationSimpleView> findByNameForUser(String text, String email, Pageable pageable);

	Page<OrganizationSimpleView> findByCountry(String country, Pageable pageable);

	Page<OrganizationSimpleView> findByType(String type, Pageable pageable);

	@Query(value = "select o.* from organizations_simple_view o left outer join user_countries uc on (uc.country = o.country) where uc.email = ?2 and o.type = ?1", nativeQuery = true)
	Page<OrganizationSimpleView> findByTypeForUser(String type, String name, Pageable pageable);

}
