/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations;

import eu.dnetlib.organizations.controller.UserInfo;
import eu.dnetlib.organizations.utils.OpenOrgsConstants;
import javax.sql.DataSource;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.access.AccessDeniedHandler;

@Profile(value={"dev"})
@Configuration
@EnableWebSecurity
public class MockSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private DataSource dataSource;
    @Value(value="${openaire.api.valid.subnet}")
    private String openaireApiValidSubnet;
    private static final String DEFAULT_PASSWORD = "dnet";
    private static Logger logger = LoggerFactory.getLogger(MockSecurityConfig.class);

    protected void configure(HttpSecurity http) throws Exception {
        http.headers().frameOptions().sameOrigin();
        ((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{"/", "/api/**"})).hasAnyRole(OpenOrgsConstants.VALID_ROLES).antMatchers(new String[]{"/registration_api/**"})).hasRole(OpenOrgsConstants.NOT_AUTORIZED_ROLE).antMatchers(new String[]{"/resources/**", "/webjars/**", "/metrics", "/health", "/dbmodel/**"})).permitAll().antMatchers(new String[]{"/oa_api/**"})).permitAll().anyRequest()).authenticated().and()).formLogin().loginPage("/login").permitAll()).and()).logout().permitAll().and()).exceptionHandling().accessDeniedHandler(this.accessDeniedHandler());
    }

    private AccessDeniedHandler accessDeniedHandler() {
        return (req, res, e) -> {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (auth != null) {
                logger.warn(String.format("User '%s' (%s) attempted to access the protected URL: %s", auth.getName(), req.getRemoteAddr(), req.getRequestURI()));
            }
            if (UserInfo.isNotAuthorized((Authentication)auth)) {
                res.sendRedirect(req.getContextPath() + "/authorizationRequest");
            } else {
                res.sendRedirect(req.getContextPath() + "/alreadyRegistered");
            }
        };
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.jdbcAuthentication().dataSource(this.dataSource).usersByUsernameQuery("select ?, '{MD5}" + DigestUtils.md5Hex((String)DEFAULT_PASSWORD) + "', true").authoritiesByUsernameQuery("with const as (SELECT ? as email) select c.email, 'ROLE_OPENORGS_'||coalesce(u.role, '" + OpenOrgsConstants.NOT_AUTORIZED_ROLE + "') from const c left outer join users u on (u.email = c.email)");
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return PasswordEncoderFactories.createDelegatingPasswordEncoder();
    }
}

