package eu.dnetlib.organizations.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;

import eu.dnetlib.common.controller.AbstractDnetController;

@Controller
public class HomeController extends AbstractDnetController {

	@Autowired
	private Environment env;

	@GetMapping("/")
	public String home() {
		return env.acceptsProfiles(Profiles.of("dev")) ? "redirect:main" : "home";
	}

	@GetMapping("/main")
	public String main() {
		return "main";
	}

	@GetMapping("/login")
	public String login() {
		return "login";
	}

	@GetMapping("/authorizationRequest")
	public String authorizationRequest() {
		return "authorizationRequest";
	}

	@GetMapping("/alreadyRegistered")
	public String alreadyRegistered() {
		return "alreadyRegistered";
	}

	@ModelAttribute("email")
	public String getUserEmail(final Authentication authentication) {
		return authentication != null ? UserInfo.getEmail(authentication) : null;
	}

	@GetMapping({
		"/doc", "/swagger"
	})
	public String apiDoc() {
		return "redirect:swagger-ui.html";
	}

}
