/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.utils;

import eu.dnetlib.organizations.controller.UserRole;
import eu.dnetlib.organizations.model.Acronym;
import eu.dnetlib.organizations.model.JournalEntry;
import eu.dnetlib.organizations.model.OpenaireConflictPK;
import eu.dnetlib.organizations.model.OpenaireDuplicate;
import eu.dnetlib.organizations.model.Organization;
import eu.dnetlib.organizations.model.OtherIdentifier;
import eu.dnetlib.organizations.model.Relationship;
import eu.dnetlib.organizations.model.Url;
import eu.dnetlib.organizations.model.User;
import eu.dnetlib.organizations.model.UserCountry;
import eu.dnetlib.organizations.model.utils.BrowseEntry;
import eu.dnetlib.organizations.model.utils.OrganizationConflict;
import eu.dnetlib.organizations.model.utils.TempBrowseEntry;
import eu.dnetlib.organizations.model.utils.VocabularyTerm;
import eu.dnetlib.organizations.model.view.OrganizationView;
import eu.dnetlib.organizations.model.view.OtherName;
import eu.dnetlib.organizations.model.view.UserView;
import eu.dnetlib.organizations.repository.AcronymRepository;
import eu.dnetlib.organizations.repository.JournalEntryRepository;
import eu.dnetlib.organizations.repository.OpenaireConflictRepository;
import eu.dnetlib.organizations.repository.OpenaireDuplicateRepository;
import eu.dnetlib.organizations.repository.OrganizationRepository;
import eu.dnetlib.organizations.repository.OtherIdentifierRepository;
import eu.dnetlib.organizations.repository.OtherNameRepository;
import eu.dnetlib.organizations.repository.RelationshipRepository;
import eu.dnetlib.organizations.repository.UrlRepository;
import eu.dnetlib.organizations.repository.UserCountryRepository;
import eu.dnetlib.organizations.repository.UserRepository;
import eu.dnetlib.organizations.repository.readonly.OrganizationViewRepository;
import eu.dnetlib.organizations.utils.DatabaseUtils;
import eu.dnetlib.organizations.utils.JournalOperations;
import eu.dnetlib.organizations.utils.OrganizationStatus;
import eu.dnetlib.organizations.utils.RelationType;
import eu.dnetlib.organizations.utils.SimilarityType;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

@Component
public class DatabaseUtils {
    @Autowired
    private AcronymRepository acronymRepository;
    @Autowired
    private OrganizationRepository organizationRepository;
    @Autowired
    private OtherIdentifierRepository otherIdentifierRepository;
    @Autowired
    private OtherNameRepository otherNameRepository;
    @Autowired
    private UrlRepository urlRepository;
    @Autowired
    private RelationshipRepository relationshipRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserCountryRepository userCountryRepository;
    @Autowired
    private OpenaireConflictRepository openaireConflictRepository;
    @Autowired
    private OpenaireDuplicateRepository openaireDuplicateRepository;
    @Autowired
    private OrganizationViewRepository organizationViewRepository;
    @Autowired
    private JournalEntryRepository journalEntryRepository;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final Log log = LogFactory.getLog(DatabaseUtils.class);

    @Transactional
    public String insertOrUpdateOrganization(OrganizationView orgView, String user, boolean isSimpleUser) {
        String newStatus;
        String oldId = StringUtils.isNotBlank((CharSequence)orgView.getId()) ? new String(orgView.getId()) : null;
        String oldStatus = oldId != null ? (String)this.organizationRepository.findById((Object)oldId).map(Organization::getStatus).orElse(null) : null;
        boolean alreadyApproved = StringUtils.equals(oldStatus, (CharSequence)OrganizationStatus.approved.toString());
        if (!isSimpleUser) {
            newStatus = OrganizationStatus.approved.toString();
        } else if (isSimpleUser && oldStatus == null) {
            newStatus = OrganizationStatus.suggested.toString();
        } else if (isSimpleUser && alreadyApproved) {
            newStatus = OrganizationStatus.approved.toString();
        } else {
            throw new RuntimeException("User not authorized");
        }
        if (oldId == null || !oldId.startsWith("openorgs____::")) {
            if (isSimpleUser) {
                String pendingId = "pending_org_::" + UUID.randomUUID();
                orgView.setId(pendingId);
                this.organizationRepository.preparePendingOrg(pendingId);
            } else {
                orgView.setId(null);
            }
        }
        Organization org = new Organization(orgView.getId(), orgView.getName(), orgView.getType(), orgView.getLat(), orgView.getLng(), orgView.getCity(), orgView.getCountry(), newStatus, orgView.getEcLegalBody(), orgView.getEcLegalPerson(), orgView.getEcNonProfit(), orgView.getEcResearchOrganization(), orgView.getEcHigherEducation(), orgView.getEcInternationalOrganizationEurInterests(), orgView.getEcInternationalOrganization(), orgView.getEcEnterprise(), orgView.getEcSmeValidated(), orgView.getEcNutscode());
        String newId = ((Organization)this.organizationRepository.save((Object)org)).getId();
        OffsetDateTime now = OffsetDateTime.now();
        if (StringUtils.equals((CharSequence)newId, (CharSequence)oldId)) {
            this.makeRelations(newId, orgView, true);
        } else {
            this.organizationRepository.updateCreationDate(newId, user, now);
            this.makeRelations(newId, orgView, false);
            if (oldId != null) {
                List<OpenaireDuplicate> dups = this.openaireDuplicateRepository.findByLocalId(oldId).stream().map(d -> new OpenaireDuplicate(newId, d.getOaOriginalId(), SimilarityType.suggested.toString(), d.getOaCollectedFrom())).collect(Collectors.toList());
                this.openaireDuplicateRepository.saveAll(dups);
                dups.forEach(d -> {
                    this.openaireDuplicateRepository.updateCreatedByIfMissing(d.getLocalId(), d.getOaOriginalId(), user);
                    this.openaireDuplicateRepository.updateModificationDate(d.getLocalId(), d.getOaOriginalId(), user, now);
                });
                if (oldId.startsWith("pending_org_::")) {
                    this.organizationRepository.deleteById((Object)oldId);
                }
            }
        }
        this.organizationRepository.updateModificationDate(newId, user, now);
        JournalOperations op = JournalOperations.UNKNOWN;
        String message = "-";
        if (newStatus.equals(OrganizationStatus.suggested.toString())) {
            if (oldStatus == null) {
                op = JournalOperations.NEW_SUGG_ORG;
                message = "Created a new suggested org";
            } else if (oldStatus != null) {
                op = JournalOperations.EDIT_SUGG_ORG;
                message = "Metadata updated";
            }
        } else if (newStatus.equals(OrganizationStatus.approved.toString())) {
            if (oldStatus == null) {
                op = JournalOperations.NEW_ORG;
                message = "Created a new organization";
            } else if (oldStatus.equals(OrganizationStatus.suggested.toString())) {
                op = JournalOperations.APPROVE_SUGG_ORG;
                message = "Approved the suggested org: " + oldId;
            } else {
                op = JournalOperations.EDIT_ORG;
                message = "Metadata updated";
            }
        }
        this.journalEntryRepository.save((Object)new JournalEntry(newId, op, message, user));
        return newId;
    }

    @Transactional
    public void saveDuplicates(List<OpenaireDuplicate> simrels, String user) {
        OffsetDateTime now = OffsetDateTime.now();
        ArrayList<OpenaireDuplicate> toSave = new ArrayList<OpenaireDuplicate>();
        toSave.addAll(simrels);
        ArrayList<OpenaireDuplicate> toDelete = new ArrayList<OpenaireDuplicate>();
        for (OpenaireDuplicate r1 : simrels) {
            if (r1.getRelType().equals(SimilarityType.is_different.toString())) continue;
            for (OpenaireDuplicate r2 : this.openaireDuplicateRepository.findByOaOriginalId(r1.getOaOriginalId())) {
                if (r2.getLocalId().startsWith("pending_org_::")) {
                    toDelete.add(r2);
                    continue;
                }
                if (r1.getLocalId().equals(r2.getLocalId())) continue;
                r2.setRelType(SimilarityType.is_different.toString());
                toSave.add(r2);
            }
        }
        this.openaireDuplicateRepository.saveAll(toSave).forEach(d -> {
            this.openaireDuplicateRepository.updateCreatedByIfMissing(d.getLocalId(), d.getOaOriginalId(), user);
            this.openaireDuplicateRepository.updateModificationDate(d.getLocalId(), d.getOaOriginalId(), user, now);
        });
        log.debug((Object)("Simrels saved (contains also the fixed rels): " + toSave.size()));
        this.openaireDuplicateRepository.deleteAll(toDelete);
        log.debug((Object)("Simrels related to a pending orgs deleted: " + toDelete.size()));
        toSave.stream().collect(Collectors.groupingBy(OpenaireDuplicate::getLocalId)).forEach((id, list) -> {
            long sim = list.stream().filter(d -> d.getRelType().equals(SimilarityType.is_similar.toString())).count();
            long diff = list.stream().filter(d -> d.getRelType().equals(SimilarityType.is_different.toString())).count();
            long sugg = list.stream().filter(d -> d.getRelType().equals(SimilarityType.suggested.toString())).count();
            String message = String.format("Duplicates updated (%s similars, %s differents, %s suggested)", sim, diff, sugg);
            this.journalEntryRepository.save((Object)new JournalEntry(id, JournalOperations.DUPLICATES, message, user));
        });
    }

    @Scheduled(fixedRate=300000L)
    public void verifyConsistency() {
        log.debug((Object)"Verify consistency (START)");
        int n = this.jdbcTemplate.update("delete from organizations where id in (select o.id from organizations o left outer join oa_duplicates d on (o.id = d.local_id) where o.status = 'suggested' and o.created_by = 'dedupWf' group by o.id having count(d.local_id) = 0)");
        if (n > 0) {
            log.info((Object)("Invalid pending orgs deleted: " + n));
        }
        log.debug((Object)"Verify consistency (END)");
    }

    private void makeRelations(String orgId, OrganizationView orgView, boolean update) {
        if (update) {
            this.acronymRepository.deleteByOrgId(orgId);
            this.otherNameRepository.deleteByOrgId(orgId);
            this.otherIdentifierRepository.deleteByOrgId(orgId);
            this.urlRepository.deleteByOrgId(orgId);
            this.relationshipRepository.deleteById1(orgId);
            this.relationshipRepository.deleteById2(orgId);
        }
        orgView.getAcronyms().forEach(s -> {
            Acronym cfr_ignored_0 = (Acronym)this.acronymRepository.save((Object)new Acronym(orgId, s));
        });
        orgView.getOtherNames().forEach(n -> {
            eu.dnetlib.organizations.model.OtherName cfr_ignored_0 = (eu.dnetlib.organizations.model.OtherName)this.otherNameRepository.save((Object)new eu.dnetlib.organizations.model.OtherName(orgId, n.getName(), n.getLang()));
        });
        orgView.getOtherIdentifiers().forEach(id -> {
            OtherIdentifier cfr_ignored_0 = (OtherIdentifier)this.otherIdentifierRepository.save((Object)new OtherIdentifier(orgId, id.getId(), id.getType()));
        });
        orgView.getUrls().forEach(u -> {
            Url cfr_ignored_0 = (Url)this.urlRepository.save((Object)new Url(orgId, u));
        });
        orgView.getRelations().forEach(r -> this.makeRelation(orgId, r.getRelatedOrgId(), RelationType.valueOf((String)r.getType())));
    }

    @Cacheable(value={"vocs"})
    public List<VocabularyTerm> listValuesOfVocabularyTable(VocabularyTable table) {
        String sql = "select val as value, name as name from " + table + " order by name";
        return this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(VocabularyTerm.class));
    }

    @Cacheable(value={"countries_for_user"})
    public List<VocabularyTerm> listCountriesForUser(String name) {
        String sql = "select uc.country as value, c.name as name from user_countries uc left outer join countries c on (c.val = uc.country) where uc.email = ? order by c.name";
        return this.jdbcTemplate.query("select uc.country as value, c.name as name from user_countries uc left outer join countries c on (c.val = uc.country) where uc.email = ? order by c.name", (RowMapper)new BeanPropertyRowMapper(VocabularyTerm.class), new Object[]{name});
    }

    @Transactional
    public void saveUser(@RequestBody UserView userView) {
        User user = (User)this.userRepository.findById((Object)userView.getEmail()).orElseThrow(() -> new RuntimeException("User not found"));
        user.setRole(userView.getRole());
        user.setValid(userView.isValid());
        this.userRepository.save((Object)user);
        this.userCountryRepository.deleteByEmail(userView.getEmail());
        if (userView.getCountries() != null) {
            this.userCountryRepository.saveAll((Iterable)Arrays.stream(userView.getCountries()).map(c -> new UserCountry(userView.getEmail(), c)).collect(Collectors.toList()));
        }
    }

    @Transactional
    public void deleteUser(String email) {
        this.userCountryRepository.deleteByEmail(email);
        this.userRepository.deleteById((Object)email);
    }

    @Transactional
    public void newUser(String email, List<String> countries) {
        User user = new User();
        user.setEmail(email);
        user.setRole(UserRole.PENDING.name());
        user.setValid(false);
        this.userRepository.save((Object)user);
        if (countries != null) {
            this.userCountryRepository.saveAll((Iterable)countries.stream().map(c -> new UserCountry(email, c)).collect(Collectors.toList()));
        }
    }

    @Transactional
    public List<Relationship> makeRelation(String id1, String id2, RelationType type) {
        Relationship r1 = new Relationship(id1, id2, type.toString());
        Relationship r2 = new Relationship(id2, id1, type.getInverse().toString());
        this.relationshipRepository.save((Object)r1);
        this.relationshipRepository.save((Object)r2);
        return Arrays.asList(r1, r2);
    }

    public List<BrowseEntry> browseCountries() {
        String sql = "select o.country as code, c.name as name, o.status as group, count(o.status) as count from organizations o left outer join countries c on (o.country = c.val) group by o.country, c.name, o.status";
        return this.listBrowseEntries("select o.country as code, c.name as name, o.status as group, count(o.status) as count from organizations o left outer join countries c on (o.country = c.val) group by o.country, c.name, o.status", new Object[0]);
    }

    public List<BrowseEntry> browseCountriesForUser(String email) {
        String sql = "select o.country as code, c.name as name, o.status as group, count(o.status) as count from user_countries uc left outer join organizations o on (uc.country = o.country) left outer join countries c on (o.country = c.val) where uc.email=? group by o.country, c.name, o.status";
        return this.listBrowseEntries("select o.country as code, c.name as name, o.status as group, count(o.status) as count from user_countries uc left outer join organizations o on (uc.country = o.country) left outer join countries c on (o.country = c.val) where uc.email=? group by o.country, c.name, o.status", new Object[]{email});
    }

    public List<BrowseEntry> browseTypes() {
        String sql = "select type as code, type as name, status as group, count(status) as count from organizations group by type, status";
        return this.listBrowseEntries("select type as code, type as name, status as group, count(status) as count from organizations group by type, status", new Object[0]);
    }

    public List<BrowseEntry> browseTypesForUser(String email) {
        String sql = "select o.type as code, o.type as name,o.status as group, count(o.status) as count from organizations o left outer join user_countries uc on (uc.country = o.country) where uc.email=? group by o.type, o.status";
        return this.listBrowseEntries("select o.type as code, o.type as name,o.status as group, count(o.status) as count from organizations o left outer join user_countries uc on (uc.country = o.country) where uc.email=? group by o.type, o.status", new Object[]{email});
    }

    private List<BrowseEntry> listBrowseEntries(String sql, Object ... params) {
        HashMap<String, BrowseEntry> map = new HashMap<String, BrowseEntry>();
        for (TempBrowseEntry t : this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(TempBrowseEntry.class), params)) {
            if (!StringUtils.isNotBlank((CharSequence)t.getCode())) continue;
            if (!map.containsKey(t.getCode())) {
                BrowseEntry e = new BrowseEntry();
                e.setCode(t.getCode());
                e.setName(t.getName());
                map.put(t.getCode(), e);
            }
            ((BrowseEntry)map.get(t.getCode())).getValues().put(t.getGroup(), t.getCount());
        }
        return map.values().stream().sorted((o1, o2) -> StringUtils.compare((String)o1.getName(), (String)o2.getName())).collect(Collectors.toList());
    }

    public List<OrganizationConflict> listConflictsForId(String id) {
        String sql = "select o.id, o.name, o.type, o.city, o.country from oa_conflicts c left outer join organizations o on (c.id2 = o.id) where o.id is not null and c.id1 = ? and c.reltype = 'suggested'";
        return this.jdbcTemplate.query("select o.id, o.name, o.type, o.city, o.country from oa_conflicts c left outer join organizations o on (c.id2 = o.id) where o.id is not null and c.id1 = ? and c.reltype = 'suggested'", (RowMapper)new BeanPropertyRowMapper(OrganizationConflict.class), new Object[]{id});
    }

    @Transactional
    public void importDedupEvents() throws Exception {
        this.jdbcTemplate.update(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/sql/importDedupEvents.sql")));
    }

    @Transactional
    public void updateFulltextIndex() {
        try {
            log.info((Object)"Updating Fulltext Index...");
            this.jdbcTemplate.queryForList("SELECT refresh_index_search()");
            log.info((Object)"...done");
        }
        catch (Exception e) {
            log.error((Object)"Error updating Fulltext Index", (Throwable)e);
        }
    }

    @Transactional
    public String fixConflictSimilars(List<String> similarIds, String user) {
        OffsetDateTime now = OffsetDateTime.now();
        List views = similarIds.stream().map(arg_0 -> ((OrganizationViewRepository)this.organizationViewRepository).findById(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        OrganizationView newOrg = new OrganizationView();
        newOrg.setId(null);
        newOrg.setStatus(null);
        newOrg.setName(this.findFirstString(views, OrganizationView::getName));
        newOrg.setType(this.findFirstString(views, OrganizationView::getType));
        newOrg.setLat(this.findFirstNumber(views, OrganizationView::getLat));
        newOrg.setLng(this.findFirstNumber(views, OrganizationView::getLng));
        newOrg.setCity(this.findFirstString(views, OrganizationView::getCity));
        newOrg.setCountry(this.findFirstString(views, OrganizationView::getCountry));
        newOrg.setOtherIdentifiers(this.findAll(views, OrganizationView::getOtherIdentifiers));
        newOrg.setOtherNames(this.findAll(views, OrganizationView::getOtherNames));
        newOrg.setAcronyms(this.findAll(views, OrganizationView::getAcronyms));
        newOrg.setUrls(this.findAll(views, OrganizationView::getUrls));
        newOrg.setRelations(this.findAll(views, OrganizationView::getRelations));
        newOrg.getOtherNames().addAll(views.stream().map(OrganizationView::getName).filter(StringUtils::isNotBlank).filter(s -> StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)newOrg.getName())).map(s -> new OtherName(s, "UNKNOWN")).collect(Collectors.toList()));
        String masterId = this.insertOrUpdateOrganization(newOrg, user, false);
        similarIds.forEach(id -> {
            this.hideConflictOrgs(masterId, id);
            this.journalEntryRepository.save((Object)new JournalEntry(masterId, JournalOperations.FIX_CONFLICT, "The org has been hidded and merged in " + masterId, user));
        });
        List<OpenaireDuplicate> newDuplicates = similarIds.stream().map(arg_0 -> ((OpenaireDuplicateRepository)this.openaireDuplicateRepository).findByLocalId(arg_0)).flatMap(l -> l.stream()).map(d -> new OpenaireDuplicate(masterId, d.getOaOriginalId(), d.getRelType(), d.getOaCollectedFrom())).collect(Collectors.toList());
        this.openaireDuplicateRepository.saveAll(newDuplicates);
        newDuplicates.forEach(d -> {
            this.openaireDuplicateRepository.updateCreatedByIfMissing(d.getLocalId(), d.getOaOriginalId(), user);
            this.openaireDuplicateRepository.updateModificationDate(d.getLocalId(), d.getOaOriginalId(), user, now);
        });
        for (String similarId : similarIds) {
            this.openaireConflictRepository.updateMultipleStatusAndResetGroup(similarId, SimilarityType.is_different.toString(), user, now);
        }
        for (int i = 0; i < similarIds.size(); ++i) {
            for (int j = i + 1; j < similarIds.size(); ++j) {
                this.openaireConflictRepository.updateStatusAndResetGroup(similarIds.get(i), similarIds.get(j), SimilarityType.is_similar.toString(), user, now);
            }
        }
        this.journalEntryRepository.save((Object)new JournalEntry(masterId, JournalOperations.FIX_CONFLICT, "New org created merging: " + StringUtils.join(similarIds, (String)", "), user));
        return masterId;
    }

    @Transactional
    public void fixConflictDifferents(List<String> differentsIds, String user) {
        OffsetDateTime now = OffsetDateTime.now();
        String message = "Mark the following orgs as different: " + StringUtils.join(differentsIds, (String)", ");
        for (int i = 0; i < differentsIds.size(); ++i) {
            for (int j = i + 1; j < differentsIds.size(); ++j) {
                this.openaireConflictRepository.updateStatusAndResetGroup(differentsIds.get(i), differentsIds.get(j), SimilarityType.is_different.toString(), user, now);
            }
            this.journalEntryRepository.save((Object)new JournalEntry(differentsIds.get(i), JournalOperations.NO_CONFLICT, message, user));
        }
    }

    @Transactional
    public Optional<User> findUser(String email) {
        Optional user = this.userRepository.findById((Object)email);
        if (user.isPresent()) {
            this.userRepository.updateLastAccess(email, OffsetDateTime.now());
        }
        return user;
    }

    private String findFirstString(List<OrganizationView> views, Function<OrganizationView, String> mapper) {
        return views.stream().map(mapper).filter(StringUtils::isNotBlank).findFirst().orElse(null);
    }

    private Double findFirstNumber(List<OrganizationView> views, Function<OrganizationView, Double> mapper) {
        return views.stream().map(mapper).filter(Objects::nonNull).filter(n -> n != 0.0).findFirst().orElse(0.0);
    }

    private <T> Set<T> findAll(List<OrganizationView> views, Function<OrganizationView, Set<T>> mapper) {
        return views.stream().map(mapper).flatMap(s -> s.stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private List<Relationship> hideConflictOrgs(String masterId, String otherId) {
        this.organizationRepository.updateStatus(otherId, OrganizationStatus.hidden.toString());
        this.openaireConflictRepository.findById((Object)new OpenaireConflictPK(masterId, otherId)).ifPresent(arg_0 -> ((OpenaireConflictRepository)this.openaireConflictRepository).delete(arg_0));
        this.openaireConflictRepository.findById((Object)new OpenaireConflictPK(otherId, masterId)).ifPresent(arg_0 -> ((OpenaireConflictRepository)this.openaireConflictRepository).delete(arg_0));
        return this.makeRelation(masterId, otherId, RelationType.Merges);
    }
}

