/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.controller;

import eu.dnetlib.common.controller.AbstractDnetController;
import eu.dnetlib.organizations.controller.ImportStatus;
import eu.dnetlib.organizations.controller.OpenaireInternalApiController;
import eu.dnetlib.organizations.utils.DatabaseUtils;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/oa_api"})
public class OpenaireInternalApiController
extends AbstractDnetController {
    @Autowired
    private DatabaseUtils databaseUtils;
    @Value(value="${openaire.api.https.proxy}")
    private String httpsProxy;
    private static final Log log = LogFactory.getLog(OpenaireInternalApiController.class);
    private final ImportExecution lastExecution = new ImportExecution(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/import/dedupEvents"})
    public ImportExecution importDedupEvents(HttpServletRequest req) {
        if (req.getRemoteAddr().equals(this.httpsProxy)) {
            log.warn((Object)("Call received by blaklisted ip (https proxy): " + req.getRemoteAddr()));
            throw new RuntimeException("Call received by blaklisted ip (https proxy): " + req.getRemoteAddr());
        }
        ImportExecution importExecution = this.lastExecution;
        synchronized (importExecution) {
            if (this.lastExecution.getStatus() == ImportStatus.RUNNING) {
                long now = System.currentTimeMillis();
                return new ImportExecution(this, null, Long.valueOf(now), Long.valueOf(now), ImportStatus.NOT_LAUNCHED, "An other import is running");
            }
            this.lastExecution.startNew("Importing dedup events - request from " + req.getRemoteAddr());
            new Thread(() -> {
                try {
                    this.databaseUtils.importDedupEvents();
                    this.lastExecution.complete();
                }
                catch (Throwable e) {
                    this.lastExecution.fail(e);
                }
            }).start();
        }
        return this.lastExecution;
    }

    @GetMapping(value={"/import/dedupEvents/status"})
    public final ImportExecution statusDedupEvents(HttpServletRequest req) {
        if (req.getRemoteAddr().equals(this.httpsProxy)) {
            log.warn((Object)("Call received by blaklisted ip (https proxy): " + req.getRemoteAddr()));
            throw new RuntimeException("Call received by blaklisted ip (https proxy): " + req.getRemoteAddr());
        }
        return this.lastExecution;
    }

    @GetMapping(value={"/refresh/fulltextIndex"})
    public final List<String> updateFulltextIndex(HttpServletRequest req) {
        if (req.getRemoteAddr().equals(this.httpsProxy)) {
            log.warn((Object)("Call received by blaklisted ip (https proxy): " + req.getRemoteAddr()));
            throw new RuntimeException("Call received by blaklisted ip (https proxy): " + req.getRemoteAddr());
        }
        new Thread(() -> ((DatabaseUtils)this.databaseUtils).updateFulltextIndex()).start();
        return Arrays.asList("Updating ...");
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

