/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations;

import eu.dnetlib.organizations.controller.UserInfo;
import eu.dnetlib.organizations.controller.UserRole;
import eu.dnetlib.organizations.model.User;
import eu.dnetlib.organizations.utils.DatabaseUtils;
import eu.dnetlib.organizations.utils.OpenOrgsConstants;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Profile(value={"!dev"})
@Configuration
@EnableWebSecurity
public class OAuth2WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private DatabaseUtils databaseUtils;
    @Autowired
    private ClientRegistrationRepository clientRegistrationRepository;
    @Value(value="${openaire.api.valid.subnet}")
    private String openaireApiValidSubnet;
    @Value(value="${openaire.override.logout.url}")
    private String openaireLogoutUrl;
    private static Logger logger = LoggerFactory.getLogger(OAuth2WebSecurityConfig.class);

    protected void configure(HttpSecurity http) throws Exception {
        http.headers().frameOptions().sameOrigin();
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{"/main", "/api/**"})).hasAnyRole(OpenOrgsConstants.VALID_ROLES).antMatchers(new String[]{"/registration_api/**"})).hasRole(OpenOrgsConstants.NOT_AUTORIZED_ROLE).antMatchers(new String[]{"/", "/common/**", "/resources/**", "/webjars/**", "/metrics", "/health", "/dbmodel/**"})).permitAll().antMatchers(new String[]{"/oa_api/**"})).hasIpAddress(this.openaireApiValidSubnet).anyRequest()).authenticated().and()).exceptionHandling().accessDeniedHandler(this.accessDeniedHandler()).and()).logout().logoutSuccessHandler((LogoutSuccessHandler)this.oidcLogoutSuccessHandler()).invalidateHttpSession(true).clearAuthentication(true).deleteCookies(new String[]{"JSESSIONID"}).and()).oauth2Login(oauth2 -> oauth2.userInfoEndpoint(userInfo -> userInfo.oidcUserService(this.oidcUserService())));
    }

    private AccessDeniedHandler accessDeniedHandler() {
        return (req, res, e) -> {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null) {
                logger.warn(String.format("User '%s' (%s) attempted to access the protected URL: %s", UserInfo.getEmail((Authentication)authentication), req.getRemoteAddr(), req.getRequestURI()));
            }
            if (UserInfo.isNotAuthorized((Authentication)authentication)) {
                res.sendRedirect(req.getContextPath() + "/authorizationRequest");
            } else {
                res.sendRedirect(req.getContextPath() + "/alreadyRegistered");
            }
        };
    }

    private OidcClientInitiatedLogoutSuccessHandler oidcLogoutSuccessHandler() {
        OidcClientInitiatedLogoutSuccessHandler handler = new OidcClientInitiatedLogoutSuccessHandler(this.clientRegistrationRepository);
        handler.setPostLogoutRedirectUri("{baseUrl}");
        handler.setRedirectStrategy((req, res, url) -> {
            if (StringUtils.isNotBlank((CharSequence)this.openaireLogoutUrl)) {
                logger.info("Performing remote logout: " + this.openaireLogoutUrl);
                res.sendRedirect(this.openaireLogoutUrl);
            } else {
                logger.info("Performing remote logout: " + url);
                res.sendRedirect(url);
            }
        });
        return handler;
    }

    private OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService() {
        OidcUserService delegate = new OidcUserService();
        return userRequest -> {
            OidcUser oidcUser = delegate.loadUser(userRequest);
            String role = "ROLE_OPENORGS_" + this.databaseUtils.findUser(oidcUser.getEmail()).map(User::getRole).filter(StringUtils::isNotBlank).orElse(UserRole.NOT_AUTHORIZED.toString());
            HashSet<SimpleGrantedAuthority> mappedAuthorities = new HashSet<SimpleGrantedAuthority>();
            mappedAuthorities.add(new SimpleGrantedAuthority(role));
            return new DefaultOidcUser(mappedAuthorities, oidcUser.getIdToken(), oidcUser.getUserInfo());
        };
    }
}

