package eu.dnetlib.organizations.metrics;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import eu.dnetlib.common.metrics.MetricInfo;
import eu.dnetlib.organizations.repository.OrganizationRepository;
import eu.dnetlib.organizations.utils.OrganizationStatus;

@Component("valid_organizations_total")
public class ValidOrganizationsMetric extends MetricInfo {

	@Autowired
	private OrganizationRepository organizationRepository;

	@Override
	public double obtainValue() {
		return organizationRepository.countByStatus(OrganizationStatus.approved.toString());
	}

}
