/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.controller;

import eu.dnetlib.common.controller.AbstractDnetController;
import eu.dnetlib.organizations.controller.UserInfo;
import eu.dnetlib.organizations.importer.ImportExecution;
import eu.dnetlib.organizations.importer.ImportExecutor;
import eu.dnetlib.organizations.model.SystemConfiguration;
import eu.dnetlib.organizations.model.utils.VocabularyTerm;
import eu.dnetlib.organizations.model.view.UserView;
import eu.dnetlib.organizations.repository.SystemConfigurationRepository;
import eu.dnetlib.organizations.repository.UserRepository;
import eu.dnetlib.organizations.repository.readonly.UserViewRepository;
import eu.dnetlib.organizations.utils.DatabaseUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AdminController
extends AbstractDnetController {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserViewRepository userViewRepository;
    @Autowired
    private SystemConfigurationRepository systemConfigurationRepository;
    @Autowired
    private ImportExecutor importExecutor;
    @Autowired
    private DatabaseUtils dbUtils;

    @PostMapping(value={"/registration_api/newUser"})
    public Map<String, Integer> newUser(@RequestBody List<String> countries, Authentication authentication) {
        String email = UserInfo.getEmail((Authentication)authentication);
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        if (!UserInfo.isNotAuthorized((Authentication)authentication) || this.userRepository.existsById((Object)email)) {
            res.put("status", 2);
        } else {
            this.dbUtils.newUser(email, countries);
            res.put("status", 1);
        }
        return res;
    }

    @GetMapping(value={"/api/users"})
    public Iterable<UserView> users(Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            return this.userViewRepository.findAll();
        }
        if (UserInfo.isNationalAdmin((Authentication)authentication)) {
            ArrayList<UserView> res = new ArrayList<UserView>();
            List myCountries = this.dbUtils.listCountriesForUser(UserInfo.getEmail((Authentication)authentication)).stream().map(VocabularyTerm::getValue).collect(Collectors.toList());
            for (UserView uw : this.userViewRepository.findAll()) {
                if (uw.getCountries() == null || uw.getCountries().length <= 0 || !myCountries.containsAll(Arrays.asList(uw.getCountries()))) continue;
                res.add(uw);
            }
            return res;
        }
        return new ArrayList<UserView>();
    }

    @PostMapping(value={"/api/users"})
    public Iterable<UserView> saveUser(@RequestBody UserView userView, Authentication authentication) {
        if (UserInfo.getEmail((Authentication)authentication).equals(userView.getEmail())) {
            throw new RuntimeException("You can't edit your own user");
        }
        this.dbUtils.saveUser(userView);
        return this.users(authentication);
    }

    @DeleteMapping(value={"/api/users"})
    public Iterable<UserView> deleteUser(@RequestParam String email, Authentication authentication) {
        if (UserInfo.getEmail((Authentication)authentication).equals(email)) {
            throw new RuntimeException("You can't delete your own user");
        }
        this.dbUtils.deleteUser(email);
        return this.users(authentication);
    }

    @GetMapping(value={"/api/sysconf"})
    public SystemConfiguration sysConf(Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            return (SystemConfiguration)this.systemConfigurationRepository.findById((Object)"default").get();
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/api/lastImportStatus"})
    private ImportExecution lastImportExecution(Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            return this.importExecutor.getLastImportExecution();
        }
        throw new RuntimeException("User not authorized");
    }

    @PostMapping(value={"/api/sysconf"})
    public SystemConfiguration saveSysConf(@RequestBody SystemConfiguration sysConf, Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            sysConf.setId("default");
            return (SystemConfiguration)this.systemConfigurationRepository.save((Object)sysConf);
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/api/refreshFulltextIndex"})
    public List<String> refreshFulltextIndex(Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            new Thread(() -> ((DatabaseUtils)this.dbUtils).updateFulltextIndex()).start();
            return Arrays.asList("The index update is in progress, please wait a few minutes");
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/api/performConsistencyCheck"})
    public List<String> performConsistencyCheck(Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            new Thread(() -> ((DatabaseUtils)this.dbUtils).verifyConsistency()).start();
            return Arrays.asList("The check is running, please wait a few minutes");
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/api/verifyCountriesInSuggestions"})
    public List<String> verifyCountriesInSuggestions(Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            List list = this.dbUtils.invalidCountriesInSuggestions();
            if (list.isEmpty()) {
                return Arrays.asList("All countries are valid");
            }
            return Arrays.asList("Invalid countries in suggestions: " + StringUtils.join((Iterable)list, (String)", "));
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/api/restartSuggestionsImport"})
    public List<String> restartSuggestionsImport(Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            this.importExecutor.startImport("the portal, user: " + authentication.getName());
            return Arrays.asList("The import is running");
        }
        throw new RuntimeException("User not authorized");
    }
}

