package eu.dnetlib.organizations;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;

import eu.dnetlib.common.app.AbstractDnetApp;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication
@EnableSwagger2
@EnableCaching
@EnableScheduling
@ComponentScan(basePackages = "eu.dnetlib")
public class MainApplication extends AbstractDnetApp {

	public static void main(final String[] args) {
		SpringApplication.run(MainApplication.class, args);
	}

	@Override
	protected void configSwagger(final Docket docket) {
		docket.select()
			.apis(RequestHandlerSelectors.any())
			.paths(p -> p.startsWith("/api/") || p.startsWith("/oa_api"))
			.build()
			.apiInfo(new ApiInfoBuilder()
				.title("D-Net Organizations Service APIs")
				.description("APIs documentation")
				.version("1.1")
				.contact(ApiInfo.DEFAULT_CONTACT)
				.license("Apache 2.0")
				.licenseUrl("http://www.apache.org/licenses/LICENSE-2.0")
				.build());
	}

}
