package eu.dnetlib.organizations.model.utils;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public interface OpenaireGraphNode {

	String getOaGraphId();

	void setOaGraphId(String oaGraphId);

	String getOaGraphUrl();

	void setOaGraphUrl(String oaGraphUrl);

	default void fillGraphNodeInfo(final String origId, final String baseUrl) {
		final String oaGraphId = StringUtils.substringBefore(origId, "::") + "::"
			+ DigestUtils.md5Hex(StringUtils.substringAfter(origId, "::"));
		setOaGraphId(oaGraphId);
		setOaGraphUrl(baseUrl + oaGraphId);
	}

}
