package eu.dnetlib.organizations.repository;

import java.time.OffsetDateTime;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import eu.dnetlib.organizations.model.User;

public interface UserRepository extends JpaRepository<User, String> {

	@Modifying
	@Query("update User set last_access = ?2 where email = ?1")
	void updateLastAccess(final String email, OffsetDateTime now);

}
