package eu.dnetlib.organizations.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "sysconf")
public class SystemConfiguration implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = -7935575713678578023L;

	public static final String DEFAULT_ID = "default";

	@Id
	@Column(name = "id")
	private String id;

	@Column(name = "title")
	private String title;

	@Column(name = "homepage_msg")
	private String homepageMessage;

	@Column(name = "readonly")
	private Boolean readonly;

	public SystemConfiguration() {}

	public SystemConfiguration(final String id, final String title, final String homepageMessage, final Boolean readonly) {
		this.id = id;
		this.title = title;
		this.homepageMessage = homepageMessage;
		this.readonly = readonly;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(final String title) {
		this.title = title;
	}

	public String getHomepageMessage() {
		return homepageMessage;
	}

	public void setHomepageMessage(final String homepageMessage) {
		this.homepageMessage = homepageMessage;
	}

	public Boolean getReadonly() {
		return readonly;
	}

	public void setReadonly(final Boolean readonly) {
		this.readonly = readonly;
	}

}
