/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.utils;

import com.opencsv.bean.ColumnPositionMappingStrategy;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.StatefulBeanToCsv;
import com.opencsv.bean.StatefulBeanToCsvBuilder;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CSVConverter {
    private static final Log log = LogFactory.getLog(CSVConverter.class);

    public static <T> void writeCSV(OutputStream out, Iterable<T> list, Class<T> clazz, String ... columns) {
        StringWriter sw = new StringWriter();
        sw.write(StringUtils.join((Object[])columns, (String)","));
        sw.write("\n");
        try {
            ColumnPositionMappingStrategy mapStrategy = new ColumnPositionMappingStrategy();
            mapStrategy.setType(clazz);
            mapStrategy.setColumnMapping(columns);
            StatefulBeanToCsv btcsv = new StatefulBeanToCsvBuilder((Writer)sw).withQuotechar('\"').withEscapechar('\"').withMappingStrategy((MappingStrategy)mapStrategy).withSeparator(',').build();
            btcsv.write(list.iterator());
            IOUtils.write((String)sw.toString(), (OutputStream)out);
        }
        catch (CsvException | IOException ex) {
            log.error((Object)"Error mapping Bean to CSV", ex);
        }
    }
}

