/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.model;

import eu.dnetlib.organizations.utils.JournalOperations;
import java.io.Serializable;
import java.time.OffsetDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="journal")
public class JournalEntry
implements Serializable {
    private static final long serialVersionUID = -6861395678624671324L;
    @Id
    @Column(name="jid")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer journalEntryId;
    @Column(name="id")
    private String orgId;
    @Column(name="operation")
    private String operation;
    @Column(name="description")
    private String description;
    @Column(name="op_date")
    private OffsetDateTime date;
    @Column(name="email")
    private String email;

    public JournalEntry() {
    }

    public JournalEntry(String orgId, JournalOperations operation, String description, String email) {
        this(orgId, operation.name(), description, email);
    }

    protected JournalEntry(String orgId, String operation, String description, String email) {
        this.orgId = orgId;
        this.operation = operation;
        this.description = description;
        this.date = OffsetDateTime.now();
        this.email = email;
    }

    public Integer getJournalEntryId() {
        return this.journalEntryId;
    }

    public void setJournalEntryId(Integer journalEntryId) {
        this.journalEntryId = journalEntryId;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

