/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.repository.readonly;

import eu.dnetlib.organizations.model.view.OrganizationSimpleView;
import eu.dnetlib.organizations.repository.readonly.ReadOnlyRepository;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface OrganizationSimpleViewRepository
extends ReadOnlyRepository<OrganizationSimpleView, String> {
    @Query(value="SELECT \n    org.id AS id,\n    org.name AS name,\n    org.type AS type,\n    org.city AS city,\n    org.country AS country,\n    org.status AS status,\n    array_remove(array_agg(DISTINCT a.acronym), NULL) AS acronyms,\n    array_remove(array_agg(DISTINCT u.url), NULL) AS urls,\n    count(DISTINCT d1.oa_original_id) FILTER (WHERE d1.reltype = 'is_similar') AS n_similar_dups,\n    count(DISTINCT d1.oa_original_id) FILTER (WHERE d1.reltype = 'suggested') AS n_suggested_dups,\n    count(DISTINCT d1.oa_original_id) FILTER (WHERE d1.reltype = 'is_different') AS n_different_dups\nFROM org_index_search idx      JOIN organizations org ON (idx.id = org.id) \n     LEFT OUTER JOIN acronyms a ON org.id = a.id\n     LEFT OUTER JOIN urls u ON org.id = u.id\n     LEFT OUTER JOIN oa_duplicates d1 ON org.id = d1.local_id\nWHERE org.status in :statuses AND (org.name ilike '%'||:text||'%' OR idx.txt @@ plainto_tsquery(:text))\nGROUP BY org.id, org.name, org.type, org.city, org.country, org.status", nativeQuery=true)
    public Page<OrganizationSimpleView> search(@Param(value="text") String var1, @Param(value="statuses") List<String> var2, Pageable var3);

    @Query(value="SELECT\n    org.id AS id,\n    org.name AS name,\n    org.type AS type,\n    org.city AS city,\n    org.country AS country,\n    org.status AS status,\n    array_remove(array_agg(DISTINCT a.acronym), NULL) AS acronyms,\n    array_remove(array_agg(DISTINCT u.url), NULL) AS urls,\n    count(DISTINCT d1.oa_original_id) FILTER (WHERE d1.reltype = 'is_similar'  ) AS n_similar_dups,\n    count(DISTINCT d1.oa_original_id) FILTER (WHERE d1.reltype = 'suggested'   ) AS n_suggested_dups,\n    count(DISTINCT d1.oa_original_id) FILTER (WHERE d1.reltype = 'is_different') AS n_different_dups\nFROM org_index_search idx\n    JOIN organizations org ON (idx.id = org.id)\n    LEFT OUTER JOIN acronyms a ON (org.id = a.id)\n    LEFT OUTER JOIN urls u ON (org.id = u.id)\n    LEFT OUTER JOIN oa_duplicates d1 ON (org.id = d1.local_id)\n    LEFT OUTER JOIN user_countries uc ON (uc.country = org.country) \nWHERE uc.email = :email AND org.status IN :statuses AND (org.name ilike '%'||:text||'%' OR idx.txt @@ plainto_tsquery(:text))\nGROUP BY org.id, org.name, org.type, org.city, org.country, org.status", nativeQuery=true)
    public Page<OrganizationSimpleView> searchForUser(@Param(value="text") String var1, @Param(value="email") String var2, @Param(value="statuses") List<String> var3, Pageable var4);

    public Page<OrganizationSimpleView> findByCountry(String var1, Pageable var2);

    public Page<OrganizationSimpleView> findByCountryAndStatus(String var1, String var2, Pageable var3);

    public Page<OrganizationSimpleView> findByType(String var1, Pageable var2);

    public Page<OrganizationSimpleView> findByTypeAndStatus(String var1, String var2, Pageable var3);

    @Query(value="select o.* from organizations_simple_view o left outer join user_countries uc on (uc.country = o.country) where uc.email = ?2 and o.type = ?1", nativeQuery=true)
    public Page<OrganizationSimpleView> findByTypeForUser(String var1, String var2, Pageable var3);

    @Query(value="select o.* from organizations_simple_view o left outer join user_countries uc on (uc.country = o.country) where o.type = ?1 and o.status = ?2 and uc.email = ?3", nativeQuery=true)
    public Page<OrganizationSimpleView> findByTypeAndStatusForUser(String var1, String var2, String var3, Pageable var4);

    @Query(value="SELECT\n    org.id AS id,\n    org.name AS name,\n    org.type AS type,\n    org.city AS city,\n    org.country AS country,\n    org.status AS status,\n    array_remove(array_agg(DISTINCT a.acronym), NULL) AS acronyms,\n    array_remove(array_agg(DISTINCT u.url), NULL) AS urls,\n    NULL AS n_similar_dups,\n    NULL AS n_suggested_dups,\n    NULL AS n_different_dups\nFROM org_index_search idx\n    JOIN organizations org ON (idx.id = org.id) \n    LEFT OUTER JOIN acronyms a ON (org.id = a.id)\n    LEFT OUTER JOIN urls u ON (org.id = u.id)\n    LEFT OUTER JOIN oa_duplicates d2 ON (org.id = d2.oa_original_id)\nWHERE org.status = 'raw' AND (org.name ilike '%'||:text||'%' OR idx.txt @@ plainto_tsquery(:text))\nGROUP BY org.id, org.name, org.type, org.city, org.country, org.status\nHAVING  not('is_similar' = ANY(array_agg(d2.reltype)))", nativeQuery=true)
    public Page<OrganizationSimpleView> searchCandidateDuplicates(@Param(value="text") String var1, Pageable var2);

    @Query(value="SELECT\n    org.id AS id,\n    org.name AS name,\n    org.type AS type,\n    org.city AS city,\n    org.country AS country,\n    org.status AS status,\n    array_remove(array_agg(DISTINCT a.acronym), NULL) AS acronyms,\n    array_remove(array_agg(DISTINCT u.url), NULL) AS urls,\n    NULL AS n_similar_dups,\n    NULL AS n_suggested_dups,\n    NULL AS n_different_dups\nFROM org_index_search idx\n    JOIN organizations org ON (idx.id = org.id) \n    LEFT OUTER JOIN acronyms a ON (org.id = a.id)\n    LEFT OUTER JOIN urls u ON (org.id = u.id)\n    LEFT OUTER JOIN oa_duplicates d2 ON (org.id = d2.oa_original_id)\n    LEFT OUTER JOIN user_countries uc ON (uc.country = org.country)\nWHERE org.status = 'raw' AND uc.email = :email AND (org.name ilike '%'||:text||'%' OR idx.txt @@ plainto_tsquery(:text))\nGROUP BY org.id, org.name, org.type, org.city, org.country, org.status\nHAVING  not('is_similar' = ANY(array_agg(d2.reltype)))", nativeQuery=true)
    public Page<OrganizationSimpleView> searchCandidateDuplicatesForUser(@Param(value="text") String var1, @Param(value="email") String var2, Pageable var3);
}

