/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.importer;

import eu.dnetlib.organizations.importer.ImportExecution;
import eu.dnetlib.organizations.importer.ImportStatus;
import eu.dnetlib.organizations.utils.DatabaseUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportExecutor {
    @Autowired
    private DatabaseUtils databaseUtils;
    private final ImportExecution lastImportExecution = new ImportExecution();

    public ImportExecution getLastImportExecution() {
        return this.lastImportExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportExecution startImport(String caller) {
        ImportExecution importExecution = this.lastImportExecution;
        synchronized (importExecution) {
            if (this.lastImportExecution.getStatus() == ImportStatus.RUNNING) {
                long now = System.currentTimeMillis();
                return new ImportExecution(null, Long.valueOf(now), Long.valueOf(now), ImportStatus.NOT_LAUNCHED, "An other import is running");
            }
            this.lastImportExecution.startNew("Importing dedup events - request from " + caller);
            new Thread(() -> {
                try {
                    this.databaseUtils.importDedupEvents();
                    this.lastImportExecution.complete();
                }
                catch (Throwable e) {
                    this.lastImportExecution.fail(e);
                }
            }).start();
        }
        return this.lastImportExecution;
    }
}

