/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.scholix.api;

import eu.dnetlib.common.app.AbstractDnetApp;
import eu.dnetlib.scholix.api.MainApplication;
import eu.dnetlib.scholix.api.ScholixAPIConstants;
import eu.dnetlib.scholix.api.TaggedCounter;
import io.micrometer.core.aop.TimedAspect;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication
@EnableSwagger2
@EnableCaching
@EnableScheduling
@ComponentScan(basePackages={"eu.dnetlib"})
public class MainApplication
extends AbstractDnetApp {
    private double scale = 1.0E9;
    private double[] histogramValues = new double[]{0.005 * this.scale, 0.01 * this.scale, 0.25 * this.scale, 0.5 * this.scale, 0.75 * this.scale, this.scale, 2.5 * this.scale, 5.0 * this.scale, 7.5 * this.scale, 10.0 * this.scale};
    @Value(value="${dhp.swagger.api.host}")
    private String swaggetHost;
    @Value(value="${dhp.swagger.api.basePath}")
    private String swaggerPath;

    public static void main(String[] args) {
        SpringApplication.run(MainApplication.class, (String[])args);
    }

    @Bean
    public TaggedCounter myCounter(MeterRegistry meterRegistry) {
        return new TaggedCounter(ScholixAPIConstants.SCHOLIX_MANAGER_COUNTER_NAME, "links", meterRegistry);
    }

    @Bean
    public TimedAspect timedAspect(MeterRegistry meterRegistry) {
        1 mf = new /* Unavailable Anonymous Inner Class!! */;
        meterRegistry.config().meterFilter((MeterFilter)mf);
        return new TimedAspect(meterRegistry);
    }

    protected void configSwagger(Docket docket) {
        docket.host(this.swaggetHost).pathMapping(this.swaggerPath).groupName("Scholexplorer API V1.0").select().apis(RequestHandlerSelectors.any()).paths(p -> p.startsWith("/v1")).build().apiInfo(new ApiInfoBuilder().title("Scholexplorer API V1.0").description(ScholixAPIConstants.API_DESCRIPTION).version("1.0").contact(ApiInfo.DEFAULT_CONTACT).license("Apache 2.0").licenseUrl("http://www.apache.org/licenses/LICENSE-2.0").build());
    }

    @Bean(name={"SpringDocketv2"})
    public Docket v2Docket() {
        Docket docket = new Docket(DocumentationType.SWAGGER_2);
        docket.host(this.swaggetHost).pathMapping(this.swaggerPath).groupName("Scholexplorer API V2.0").select().apis(RequestHandlerSelectors.any()).paths(p -> p.startsWith("/v2")).build().apiInfo(new ApiInfoBuilder().title("Scholexplorer API V2.0").description(ScholixAPIConstants.API_DESCRIPTION).version("2.0").contact(ApiInfo.DEFAULT_CONTACT).license("Apache 2.0").licenseUrl("http://www.apache.org/licenses/LICENSE-2.0").build());
        return docket;
    }

    static /* synthetic */ double[] access$000(MainApplication x0) {
        return x0.histogramValues;
    }
}

