/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.scholix.api.controller;

import eu.dnetlib.dhp.schema.sx.api.model.v2.LinkProviderType;
import eu.dnetlib.scholix.api.ScholixException;
import eu.dnetlib.scholix.api.index.ScholixIndexManager;
import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2"})
@Api(tags={"LinkProvider : Operation related to the Link Provider"})
public class LinkProviderV2 {
    @Autowired
    ScholixIndexManager manager;

    @Operation(summary="Get all Link Providers", description="Return a list of link provider and relative number of relations")
    @GetMapping(value={"/LinkProvider"})
    public List<LinkProviderType> getLinkProviders(@Parameter(in=ParameterIn.QUERY, description="Filter the link provider name") @RequestParam(required=false) String name) throws ScholixException {
        List result = this.manager.totalLinksByProvider(name);
        if (result == null) {
            return new ArrayList<LinkProviderType>();
        }
        return result.stream().map(s -> new LinkProviderType().name((String)s.getLeft()).totalRelationships(Integer.valueOf(((Long)s.getValue()).intValue()))).collect(Collectors.toList());
    }
}

