package eu.dnetlib.actionmanager.set;

import java.util.UUID;

import javax.xml.bind.annotation.XmlRootElement;

import eu.dnetlib.miscutils.datetime.DateUtils;

@XmlRootElement
public class RawSet {

	public static final String RAWSET_PREFIX = "rawset";

	private String id = null;
	private String creationDate = null;
	private String lastUpdate = null;

	public RawSet() {

	}

	protected RawSet(final String id, final String creationDate, final String lastUpdate) {
		super();
		this.id = id;
		this.creationDate = creationDate;
		this.lastUpdate = lastUpdate;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getCreationDate() {
		return creationDate;
	}

	public void setCreationDate(final String creationDate) {
		this.creationDate = creationDate;
	}

	public String getLastUpdate() {
		return lastUpdate;
	}

	public void setLastUpdate(final String lastUpdate) {
		this.lastUpdate = lastUpdate;
	}

	public static RawSet newInstance() {
		long now = DateUtils.now();
		return new RawSet(RAWSET_PREFIX + "_" + UUID.randomUUID() + "_" + now, DateUtils.calculate_ISO8601(now), null);
	}

	public static RawSet newInstance(final String id, final String creationDate, final String lastUpdate) {
		return new RawSet(id, creationDate, lastUpdate);
	}

}
