/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.set;

import eu.dnetlib.actionmanager.set.RawSet;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.time.DateUtils;

@XmlRootElement
public class ActionManagerSet
implements Serializable {
    private static final long serialVersionUID = 7262893241919858735L;
    public static final String[] DATE_PATTERNS = new String[]{"yyyy-MM-dd'T'hh:mm:ss+00:00", "yyyy-MM-dd'T'hh:mm:ssXXX"};
    private String id;
    private String name;
    private ImpactTypes impact = ImpactTypes.INSERT_UPDATE;
    private String directory;
    private String pathToLatest;
    private RawSet latest;
    private TreeSet<RawSet> expired;

    public ActionManagerSet() {
        this.expired = new TreeSet<RawSet>(this.getRawSetComparator());
    }

    public ActionManagerSet(String id, String name, String directory) {
        this(id, name, directory, ImpactTypes.INSERT_UPDATE, null);
    }

    public ActionManagerSet(String id, String name, String directory, ImpactTypes impact, RawSet latest) {
        this(id, name, directory, impact, null, latest);
    }

    public ActionManagerSet(String id, String name, String directory, ImpactTypes impact, String pathToLatest, RawSet latest) {
        this.id = id;
        this.name = name;
        this.directory = directory;
        this.impact = impact;
        this.pathToLatest = pathToLatest;
        this.latest = latest;
        this.expired = new TreeSet<RawSet>(this.getRawSetComparator());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ImpactTypes getImpact() {
        return this.impact;
    }

    public void setImpact(ImpactTypes impact) {
        this.impact = impact;
    }

    public String getPathToLatest() {
        return this.pathToLatest;
    }

    public void setPathToLatest(String pathToLatest) {
        this.pathToLatest = pathToLatest;
    }

    public String toString() {
        return "[ id: " + this.id + ", name: " + this.name + ", impact: " + (Object)((Object)this.impact) + " ]";
    }

    public RawSet getLatest() {
        return this.latest;
    }

    public void setLatest(RawSet latest) {
        this.latest = latest;
    }

    public void setLatest(String rawSetId, String creationDate, String lastUpdate) {
        this.setLatest(new RawSet(rawSetId.trim(), creationDate.trim(), lastUpdate.trim()));
    }

    private Comparator<RawSet> getRawSetComparator() {
        return new Comparator<RawSet>(){

            @Override
            public int compare(RawSet o1, RawSet o2) {
                try {
                    Date d1 = DateUtils.parseDate((String)o1.getLastUpdate(), (String[])DATE_PATTERNS);
                    Date d2 = DateUtils.parseDate((String)o2.getLastUpdate(), (String[])DATE_PATTERNS);
                    return d1.compareTo(d2);
                }
                catch (ParseException e) {
                    throw new RuntimeException(String.format("unable to parse dates: %s, %s. Known patterns: %s", o1.getLastUpdate(), o2.getLastUpdate(), Arrays.asList(DATE_PATTERNS)));
                }
            }
        };
    }

    public Set<RawSet> getExpired() {
        return this.expired;
    }

    public void addExpired(String rawSetId, String creationDate, String lastUpdate) {
        this.addExpired(new RawSet(rawSetId.trim(), creationDate.trim(), lastUpdate.trim()));
    }

    public void addExpired(RawSet rawSet) {
        this.getExpired().add(rawSet);
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public static enum ImpactTypes {
        ONLY_INSERT,
        INSERT_UPDATE;

    }
}

