package eu.dnetlib.actionmanager.actions;

import com.google.gson.GsonBuilder;
import eu.dnetlib.actionmanager.ActionManagerConstants.ACTION_TYPE;
import eu.dnetlib.actionmanager.common.Agent;

public class AtomicAction extends AbstractAction {

	private String targetRowKey;
	private String targetColumnFamily;
	private String targetColumn;

	private byte[] targetValue;

	public AtomicAction(final String rawSet, final Agent agent) {
		super(ACTION_TYPE.aac, rawSet, agent);
	}

	public AtomicAction(final String rawSet, final Agent agent, final String targetRowKey, final String targetColumnFamily,
			final String targetColumn, final byte[] targetValue) {
		this(rawSet, agent);
		this.targetRowKey = targetRowKey;
		this.targetColumnFamily = targetColumnFamily;
		this.targetColumn = targetColumn;
		this.targetValue = targetValue;
	}

	public static AtomicAction fromJSON(String s) {
		final GsonBuilder gson = new GsonBuilder();
		gson.registerTypeAdapter(AtomicAction.class, new AtomicActionDeserialiser());
		return gson.create().fromJson(s, AtomicAction.class);
	}

	public String toJSON() {
		final GsonBuilder gson = new GsonBuilder();
		gson.registerTypeAdapter(AtomicAction.class, new AtomicActionSerialiser());
		return gson.create().toJson(this);
	}

	public String getTargetRowKey() {
		return targetRowKey;
	}

	public void setTargetRowKey(final String targetRowKey) {
		this.targetRowKey = targetRowKey;
	}

	public String getTargetColumnFamily() {
		return targetColumnFamily;
	}

	public void setTargetColumnFamily(final String targetColumnFamily) {
		this.targetColumnFamily = targetColumnFamily;
	}

	public String getTargetColumn() {
		return targetColumn;
	}

	public void setTargetColumn(final String targetColumn) {
		this.targetColumn = targetColumn;
	}

	public byte[] getTargetValue() {
		return targetValue;
	}

	public void setTargetValue(final byte[] targetValue) {
		this.targetValue = targetValue;
	}

	public boolean isValid() {
		return ((getRowKey() != null) && !getRowKey().isEmpty() && (getRawSet() != null) && !getRawSet().isEmpty() && (targetRowKey != null)
				&& !targetRowKey.isEmpty() && (targetColumnFamily != null) && !targetColumnFamily.isEmpty() && (targetColumn != null)
				&& !targetColumn.isEmpty() && (targetValue != null) && (targetValue.length > 0));
	}

	@Override
	public String toString() {
		return toJSON();
	}

}
