/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.inspector;

import eu.dnetlib.actionmanager.ActionManagerConstants;
import eu.dnetlib.actionmanager.blackboard.JobLauncher;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.is.ISClient;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ActionManagerController
extends AbstractInspectorController {
    @Autowired
    private ISClient isClient;
    @Autowired
    private JobLauncher jobLauncher;

    @ModelAttribute(value="types")
    public ActionManagerConstants.ACTION_TYPE[] listActionTypes() {
        return ActionManagerConstants.ACTION_TYPE.values();
    }

    @ModelAttribute(value="provenances")
    public Provenance[] listProvenances() {
        return Provenance.values();
    }

    @ModelAttribute(value="sets")
    public List<ActionManagerSet> listSets() throws ActionManagerException {
        return this.isClient.listSets();
    }

    @RequestMapping(value={"/inspector/actions/createSet.do"})
    public String createSet(ModelMap map, @RequestParam(value="id", required=true) String id, @RequestParam(value="name", required=true) String name, @RequestParam(value="directory", required=true) String directory) throws Exception {
        this.isClient.registerSetProfile(new ActionManagerSet(id, name, directory));
        return "redirect:listSets.do";
    }

    @RequestMapping(value={"/inspector/actions/listSets.do"})
    public void createSet(ModelMap map) throws Exception {
        map.addAttribute("sets", this.isClient.listValidSets());
    }

    @RequestMapping(value={"/inspector/actions/commit.do"})
    public void commit(ModelMap map, @RequestParam(value="sets", required=false) Set<String> sets) throws Exception {
        this.jobLauncher.executePromoteFromHDFSJob(sets, null);
        map.addAttribute("message", (Object)"Job launched !!!");
    }

    @RequestMapping(value={"/inspector/actions/garbage.do"})
    public void garbage(ModelMap map) throws Exception {
        this.jobLauncher.executeGarbageActions();
        map.addAttribute("message", (Object)"Job launched !!!");
    }

    @RequestMapping(value={"/inspector/actions/deleteSet.do"})
    public String deleteSet(ModelMap map, @RequestParam(value="set", required=true) String set) throws Exception {
        map.addAttribute("allSets", (Object)"__ALL__");
        if (set != null && !set.isEmpty()) {
            this.isClient.deleteSetProfile(set);
        }
        return "redirect:listSets.do";
    }

    @RequestMapping(value={"/inspector/actions/linkActionSetProfile.do"})
    public String linkProfile(@RequestParam(value="set", required=true) String set) throws Exception {
        if (StringUtils.isBlank((String)set)) {
            throw new IllegalArgumentException("missing set id");
        }
        String profileId = this.isClient.getProfileId(set);
        return "redirect:/mvc/inspector/index.do/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType/" + profileId + "/show";
    }
}

