/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.blackboard;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.actionmanager.blackboard.BlackboardJobListener;
import eu.dnetlib.actionmanager.blackboard.JobCallback;
import eu.dnetlib.actionmanager.is.ISClient;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.actionmanager.set.RawSet;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopBlackboardActions;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardClientHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobRegistry;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;

public class JobLauncher {
    public static final String ALL_SETS = "__ALL__";
    public static final String SEMICOLON = ";";
    public static final String COLON = ",";
    public static final String SEQFILE_INPUTFORMAT = "org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat";
    private static final String UPDATE_ACTION_PROFILE = "for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'ActionManagerSetDSResourceType' and .//SET/@id = '%s'] return update delete $x//RAW_SETS/EXPIRED[@id = '%s']";
    private static final Log log = LogFactory.getLog(JobLauncher.class);
    private final Executor executor = Executors.newCachedThreadPool();
    @Resource
    private UniqueServiceLocator serviceLocator;
    private ISClient infomationServiceClient;
    @Resource
    private BlackboardClientHandler blackboardClientHandler;
    @Resource
    private BlackboardJobRegistry jobRegistry;
    @Autowired
    private ISClient isClient;
    @Value(value="${services.actionmanager.promote.mapper.class}")
    private String promoteJobMapperClass;
    private String actionTable;
    private String dataTable;

    public void executePromoteFromHDFSJob(Set<String> sets, JobCallback callback) throws ActionManagerException, ISLookUpException {
        log.info((Object)("Starting commit m/r job; sets=" + sets));
        ArrayList paths = Lists.newArrayList();
        if (sets == null || sets.isEmpty()) {
            for (ActionManagerSet set : this.infomationServiceClient.listSets()) {
                paths.add(set.getPathToLatest());
            }
        } else {
            for (String setId : sets) {
                if (this.infomationServiceClient.existsSet(setId)) {
                    ActionManagerSet set = this.infomationServiceClient.getSet(setId);
                    paths.add(set.getPathToLatest());
                    continue;
                }
                log.error((Object)("Invalid set " + setId));
                throw new ActionManagerException("Invalid set " + setId);
            }
        }
        final HadoopService hadoopService = (HadoopService)this.serviceLocator.getService(HadoopService.class);
        ArrayList existingPaths = Lists.newArrayList((Iterable)Iterables.filter((Iterable)paths, (Predicate)new Predicate<String>(){

            public boolean apply(String path) {
                try {
                    boolean exist = hadoopService.existHdfsPath(ClusterName.DM.toString(), path);
                    if (!exist) {
                        log.warn((Object)String.format("path '%s' doesn't exist on DM cluster'", path));
                    }
                    return exist;
                }
                catch (HadoopServiceException e) {
                    log.error((Object)e);
                    return false;
                }
            }
        }));
        HashMap params = Maps.newHashMap();
        params.put("mapred.input.dir.formats", Joiner.on((String)COLON).join(Iterables.transform((Iterable)existingPaths, (Function)new Function<String, String>(){

            public String apply(String path) {
                return path + JobLauncher.SEMICOLON + JobLauncher.SEQFILE_INPUTFORMAT;
            }
        })));
        params.put("mapred.input.dir.mappers", Joiner.on((String)COLON).join(Iterables.transform((Iterable)existingPaths, (Function)new Function<String, String>(){

            public String apply(String path) {
                return path + JobLauncher.SEMICOLON + JobLauncher.this.promoteJobMapperClass;
            }
        })));
        params.put("hbase.mapred.outputtable", this.dataTable);
        params.put("hbase.mapreduce.outputtable", this.dataTable);
        log.info((Object)("promoting HDFS rawsets: " + existingPaths));
        this.executeHDFS("promoteMultipleActionSetsJob", params, callback);
    }

    private void executeHDFS(final String jobName, final Map<String, String> params, final JobCallback callback) throws ActionManagerException {
        if (params == null || params.isEmpty()) {
            throw new ActionManagerException("Missing HDFS paths");
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String serviceId = JobLauncher.this.findHadoopServiceProfileID();
                    BlackboardJob bbJob = JobLauncher.this.blackboardClientHandler.newJob(serviceId);
                    bbJob.setAction(HadoopBlackboardActions.SUBMIT_MAPREDUCE_JOB.toString());
                    bbJob.getParameters().put("job.name", jobName);
                    bbJob.getParameters().put("cluster", ClusterName.DM.toString());
                    bbJob.getParameters().putAll(params);
                    JobLauncher.this.jobRegistry.registerJobListener(bbJob, (eu.dnetlib.enabling.tools.blackboard.BlackboardJobListener)new BlackboardJobListener(callback));
                    JobLauncher.this.blackboardClientHandler.assign(bbJob);
                }
                catch (Exception e) {
                    log.error((Object)("Error launching m/r job: " + jobName), (Throwable)e);
                    throw new RuntimeException("Error launching m/r job: " + jobName, e);
                }
            }
        });
    }

    public void executeGarbageActions() throws ISRegistryException, HadoopServiceException, ParseException, ActionManagerException {
        String basePath = this.isClient.getBasePathHDFS();
        Integer garbageRetain = Integer.valueOf(this.isClient.getGarbageRetainThreshold());
        Long dateLimit = DateUtils.now() - Long.valueOf(this.isClient.getGarbageTimeMargin());
        HadoopService hadoopService = (HadoopService)this.serviceLocator.getService(HadoopService.class);
        ISRegistryService isRegistry = (ISRegistryService)this.serviceLocator.getService(ISRegistryService.class);
        for (ActionManagerSet set : this.isClient.listValidSets()) {
            for (RawSet expired : Iterables.limit((Iterable)set.getExpired(), (int)garbageRetain)) {
                Date d = org.apache.commons.lang.time.DateUtils.parseDate((String)expired.getLastUpdate(), (String[])ActionManagerSet.DATE_PATTERNS);
                if (d.getTime() >= dateLimit) continue;
                log.info((Object)String.format("removing raw action set %s/%s", set.getId(), expired.getId()));
                hadoopService.deleteHdfsPath(ClusterName.DM.toString(), basePath + "/" + set.getDirectory() + "/" + expired.getId());
                String xUpdate = String.format(UPDATE_ACTION_PROFILE, set.getId(), expired.getId());
                log.info((Object)String.format("updating ActionSet profile: %s", xUpdate));
                isRegistry.executeXUpdate(xUpdate);
            }
        }
    }

    private String findHadoopServiceProfileID() throws Exception {
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("collection('/db/DRIVER/ServiceResources/HadoopServiceResourceType')//RESOURCE_IDENTIFIER/@value/string()");
    }

    public String getActionTable() {
        return this.actionTable;
    }

    @Required
    public void setActionTable(String actionTable) {
        this.actionTable = actionTable;
    }

    public String getDataTable() {
        return this.dataTable;
    }

    @Required
    public void setDataTable(String dataTable) {
        this.dataTable = dataTable;
    }

    public ISClient getInfomationServiceClient() {
        return this.infomationServiceClient;
    }

    @Required
    public void setInfomationServiceClient(ISClient infomationServiceClient) {
        this.infomationServiceClient = infomationServiceClient;
    }
}

