package eu.dnetlib.actionmanager;

import java.util.List;
import javax.jws.WebParam;

import eu.dnetlib.actionmanager.is.ISClient;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.rmi.ActionManagerService;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import org.apache.hadoop.fs.Path;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class ActionManagerServiceImpl extends AbstractBaseService implements ActionManagerService {

	private NotificationHandler notificationHandler;

	@Autowired
	private ISClient isClient;

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	public String createSet(@WebParam(name = "set") final ActionManagerSet set) throws ActionManagerException {
		try {
			final String basePath = isClient.getBasePathHDFS();
			final Path actionSetPath = new Path(basePath + "/" + set.getId());
			serviceLocator.getService(HadoopService.class).createHdfsDirectory(ClusterName.DM.toString(), actionSetPath.toString(), true);
			return isClient.registerSetProfile(set);
		} catch (HadoopServiceException e) {
			throw new ActionManagerException(e);
		}
	}

	@Override
	public boolean deleteSet(@WebParam(name = "set") final String setId) throws ActionManagerException {
		try {
			final String basePath = isClient.getBasePathHDFS();
			final Path actionSetPath = new Path(basePath + "/" + setId);
			serviceLocator.getService(HadoopService.class).deleteHdfsPath(ClusterName.DM.toString(), actionSetPath.toString());
			return isClient.deleteSetProfile(setId);
		} catch (HadoopServiceException e) {
			throw new ActionManagerException(e);
		}
	}

	@Override
	public List<ActionManagerSet> ListSets() throws ActionManagerException {
		return isClient.listValidSets();
	}

	@Override
	public void notify(final String subscriptionId, final String topic, final String isId, final String message) {
		notificationHandler.notified(subscriptionId, topic, isId, message);
	}

	public NotificationHandler getNotificationHandler() {
		return notificationHandler;
	}

	@Required
	public void setNotificationHandler(final NotificationHandler notificationHandler) {
		this.notificationHandler = notificationHandler;
	}

}
