package eu.dnetlib.actionmanager.inspector;

import java.util.List;
import java.util.Set;

import eu.dnetlib.actionmanager.ActionManagerConstants.ACTION_TYPE;
import eu.dnetlib.actionmanager.blackboard.JobLauncher;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.is.ISClient;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ActionManagerController extends AbstractInspectorController {

	@Autowired
	private ISClient isClient;

	@Autowired
	private JobLauncher jobLauncher;

	@ModelAttribute(value = "types")
	public ACTION_TYPE[] listActionTypes() {
		return ACTION_TYPE.values();
	}

	@ModelAttribute(value = "provenances")
	public Provenance[] listProvenances() {
		return Provenance.values();
	}

	@ModelAttribute(value = "sets")
	public List<ActionManagerSet> listSets() throws ActionManagerException {
		return isClient.listSets();
	}

	@RequestMapping("/inspector/actions/createSet.do")
	public String createSet(final ModelMap map,
			@RequestParam(value = "id", required = true) final String id,
			@RequestParam(value = "name", required = true) final String name,
			@RequestParam(value = "directory", required = true) final String directory) throws Exception {
		isClient.registerSetProfile(new ActionManagerSet(id, name, directory));
		return "redirect:listSets.do";
	}

	@RequestMapping("/inspector/actions/listSets.do")
	public void createSet(final ModelMap map) throws Exception {
		map.addAttribute("sets", isClient.listValidSets());
	}

	@RequestMapping("/inspector/actions/commit.do")
	public void commit(final ModelMap map, @RequestParam(value = "sets", required = false) final Set<String> sets) throws Exception {
		jobLauncher.executePromoteFromHDFSJob(sets, null);
		map.addAttribute("message", "Job launched !!!");
	}

	@RequestMapping("/inspector/actions/garbage.do")
	public void garbage(final ModelMap map) throws Exception {
		jobLauncher.executeGarbageActions();
		map.addAttribute("message", "Job launched !!!");
	}

	@RequestMapping("/inspector/actions/deleteSet.do")
	public String deleteSet(final ModelMap map, @RequestParam(value = "set", required = true) final String set) throws Exception {
		map.addAttribute("allSets", JobLauncher.ALL_SETS);
		if (set != null && !set.isEmpty()) {
			isClient.deleteSetProfile(set);
		}
		return "redirect:listSets.do";
	}

	@RequestMapping("/inspector/actions/linkActionSetProfile.do")
	public String linkProfile(@RequestParam(value = "set", required = true) final String set) throws Exception {
		if (StringUtils.isBlank(set)) {
			throw new IllegalArgumentException("missing set id");
		}
		final String profileId = isClient.getProfileId(set);
		return "redirect:/mvc/inspector/index.do/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType/" + profileId + "/show";
	}

}
