<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Retrieve information about current Content Provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="DeleteMetaWorkflow"/>
	</ARCS>
</NODE>

<NODE name="DeleteMetaWorkflow" type="DeleteMetaWf">
	<DESCRIPTION>Delete the MetaWorkflow</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="metaWfId" managedBy="system">$params.("META_WORKFLOW_ID")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="DeleteMDStoreNative"/>
	</ARCS>
</NODE>

<NODE name="DeleteMDStoreNative" type="DeleteMDStore">
	<DESCRIPTION>Delete the native mdstore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdstoreId" managedBy="system">$params.("coll_id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="DeleteMDStoreTransformed"/>
	</ARCS>
</NODE>

<NODE name="DeleteMDStoreTransformed" type="DeleteMDStore">
	<DESCRIPTION>Delete the transformed mdstore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdstoreId" managedBy="system">$params.("tran_id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="DeleteIndex"/>
	</ARCS>
</NODE>

<NODE name="DeleteIndex" type="DeleteIndex">
	<DESCRIPTION>Delete the index</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="indexId" managedBy="system">$params.("index_id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="prepareOAI"/>
	</ARCS>
</NODE>

<NODE name="prepareOAI" type="PrepareOaiJob">
     <DESCRIPTION>Prepare oai feeding</DESCRIPTION>
     <PARAMETERS>
		<PARAM managedBy="user" name="oaiDbName" required="true" type="string">oaistore_dnet</PARAM>
		<PARAM managedBy="user" name="oaiFormat" required="true" type="string">DMF</PARAM>
		<PARAM managedBy="user" name="oaiLayout" required="true" type="string">store</PARAM>
		<PARAM managedBy="user" name="oaiInterpretation" required="true" type="string">transformed</PARAM>
		<PARAM name="oaiSource" managedBy="system" type="string" required="true">$params.("dataprovider:name")$</PARAM>
     </PARAMETERS>
     <ARCS>
		<ARC to="DropOAIStore"/>
     </ARCS>
</NODE>

<NODE name="DropOAIStore" type="OAIDropStore">
	<DESCRIPTION>Delete the OAI store for this repo</DESCRIPTION>
	<PARAMETERS>
		<PARAM managedBy="user" name="oaiDbName" required="true" type="string">oaistore_dnet</PARAM>
        <PARAM managedBy="user" name="oaiFormat" required="true" type="string">DMF</PARAM>
        <PARAM managedBy="user" name="oaiLayout" required="true" type="string">store</PARAM>
        <PARAM managedBy="user" name="oaiInterpretation" required="true" type="string">transformed</PARAM>
        <PARAM name="oaiSource" managedBy="system" type="string" required="true">$params.("dataprovider:name")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="OAISetsCountUpdate"/>
	</ARCS>
</NODE>

<NODE name="OAISetsCountUpdate" type="OAISetsCountUpdate">
	<DESCRIPTION>Update counts on OAI configuration sets</DESCRIPTION>
	<PARAMETERS>
		<PARAM managedBy="user" name="configuredOnly" required="true" type="boolean">true</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="RemoveApiExtraFields"/>
	</ARCS>
</NODE>

<NODE name="RemoveApiExtraFields" type="RemoveApiExtraFields">
	<DESCRIPTION>Reset the extrafields of the api</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="fields" managedBy="system">last_collection_total, last_collection_date, last_collection_mdId, last_aggregation_total, last_aggregation_date, last_aggregation_mdId</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>