<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="prepareOAI"/>
	</ARCS>
</NODE>
 
<NODE name="prepareOAI" type="PrepareOaiJob">
     <DESCRIPTION>Prepare oai feeding</DESCRIPTION>
     <PARAMETERS>
		<PARAM managedBy="user" name="oaiDbName" required="true" type="string">oaistore_dnet</PARAM>
		<PARAM managedBy="user" name="oaiFormat" required="true" type="string">DMF</PARAM>
		<PARAM managedBy="user" name="oaiLayout" required="true" type="string">store</PARAM>
		<PARAM managedBy="user" name="oaiInterpretation" required="true" type="string">transformed</PARAM>
		<PARAM name="oaiSource" managedBy="system" type="string" required="true">$params.("dataprovider:name")$</PARAM>
     </PARAMETERS>
     <ARCS>
		<ARC to="CompoundIndexes"/>
     </ARCS>
</NODE>
 
<NODE name="CompoundIndexes" type="OAICreateIndex">
     <DESCRIPTION>Create composite indexes for the OAI store</DESCRIPTION>
     <PARAMETERS>
		<PARAM managedBy="user" name="fieldNames" required="true" type="string">set,datestamp</PARAM>
     </PARAMETERS>
     <ARCS>
		<ARC to="ConfigIndexes"/>
     </ARCS>
</NODE>
 
<NODE name="ConfigIndexes" type="OAIEnsureIndexes">
     <DESCRIPTION>Create indexes on fields as specified in the configuration profile</DESCRIPTION>
     <PARAMETERS></PARAMETERS>
     <ARCS>
		<ARC to="RefreshConfig"/>
     </ARCS>
</NODE>
<NODE name="RefreshConfig" type="OAIRefreshConfiguration">
	<DESCRIPTION>Reads the current OAI configuration and updates the OAI sets accordingly</DESCRIPTION>
		<PARAMETERS></PARAMETERS>
		<ARCS>
			<ARC to="SetsCount" />
		</ARCS>
 </NODE>
<NODE name="SetsCount" type="OAISetsCountUpdate">
     <DESCRIPTION>Count records in each OAI set, for each exported metadata format linked to the given oai collection</DESCRIPTION>
     <PARAMETERS>
		<PARAM managedBy="system" name="configuredOnly" required="true" type="boolean">true</PARAM>
     </PARAMETERS>
     <ARCS>
		<ARC to="success"/>
     </ARCS>
</NODE>