<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="fetchMDStore"/>
	</ARCS>
</NODE>

<NODE name="fetchMDStore" type="FetchMDStoreRecords">
	<DESCRIPTION>Read from mdstore</DESCRIPTION>
	<PARAMETERS>
		<PARAM name="eprParam" managedBy="system" type="string" required="true">oai_epr</PARAM>
		<PARAM name="mdId" managedBy="system" type="string" required="true">$params.("tran_id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="oaiSync" />
	</ARCS>
</NODE>

<NODE name="oaiSync" type="SyncOAIStores">
	<DESCRIPTION>Synchronizes OAI stores</DESCRIPTION>
	<PARAMETERS>
		<PARAM name="eprParam" managedBy="system" type="string" required="true">oai_epr</PARAM>
		<PARAM name="oaiSource" managedBy="system" type="string" required="true">$params.("dataprovider:name")$</PARAM>
		<PARAM name="oaiDbName" managedBy="user" type="string" required="true">oaistore_dnet</PARAM>
		<PARAM name="oaiFormat" managedBy="user" type="string" required="true">$params.("tran_format")$</PARAM>
		<PARAM name="oaiLayout" managedBy="user" type="string" required="true">$params.("tran_layout")$</PARAM>
		<PARAM name="oaiInterpretation" managedBy="user" type="string" required="true">$params.("tran_interpretation")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success" />
	</ARCS>
</NODE>