/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.HTTPWithFileName;

import eu.dnetlib.data.collector.plugins.HTTPWithFileName.Connector;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.json.XML;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HTTPWithFileNameCollectorIterable
implements Iterable<String> {
    private static final Log log = LogFactory.getLog(HTTPWithFileNameCollectorIterable.class);
    private static final String TERMINATOR = "FINITO";
    private static final String JUNK = "<resource><url>%s</url><DOI>JUNK</DOI></resource>";
    public static final String APP_JSON = "application/json";
    public static final String APP_XML = "application/xml";
    public static final String TEXT_HTML = "text/html";
    private final ArrayBlockingQueue<String> queue = new ArrayBlockingQueue(100);
    private long waitTime = 60L;
    private final ArrayList<String> urls = new ArrayList();
    private final ArrayList<String> metas = new ArrayList();
    private String filterParam;
    int total = 0;
    int filtered = 0;

    public HTTPWithFileNameCollectorIterable(String startUrl, String filter) {
        if (!startUrl.isEmpty()) {
            this.urls.add(startUrl);
        }
        this.filterParam = filter;
        Thread ft = new Thread(new FillMetaQueue());
        ft.start();
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private String last = null;

            @Override
            public boolean hasNext() {
                return !Objects.equals(this.last, HTTPWithFileNameCollectorIterable.TERMINATOR);
            }

            @Override
            public String next() {
                try {
                    this.last = (String)HTTPWithFileNameCollectorIterable.this.queue.poll(HTTPWithFileNameCollectorIterable.this.waitTime, TimeUnit.SECONDS);
                    if (Objects.equals(this.last, HTTPWithFileNameCollectorIterable.TERMINATOR)) {
                        log.info((Object)"found terminator, omg!");
                    }
                }
                catch (InterruptedException e) {
                    log.warn((Object)String.format("could not find elements to consume for more than %s%s", new Object[]{HTTPWithFileNameCollectorIterable.this.waitTime, TimeUnit.SECONDS}));
                    throw new NoSuchElementException(e.getMessage());
                }
                return this.last;
            }
        };
    }

    private class FillMetaQueue
    implements Runnable {
        final Connector c = new Connector();

        private FillMetaQueue() {
        }

        public void fillQueue() {
            while (HTTPWithFileNameCollectorIterable.this.metas.size() > 0 || HTTPWithFileNameCollectorIterable.this.urls.size() > 0) {
                String url;
                log.debug((Object)("metas.size() = " + HTTPWithFileNameCollectorIterable.this.metas.size() + " urls.size() = " + HTTPWithFileNameCollectorIterable.this.urls.size() + " queue.size() = " + HTTPWithFileNameCollectorIterable.this.queue.size()));
                if (HTTPWithFileNameCollectorIterable.this.metas.size() > 0) {
                    url = (String)HTTPWithFileNameCollectorIterable.this.metas.remove(0);
                    try {
                        this.c.get(url);
                    }
                    catch (CollectorServiceException e) {
                        log.info((Object)("Impossible to collect url: " + url + " error: " + e.getMessage()));
                    }
                    if (!this.c.isStatusOk()) continue;
                    try {
                        String ret = this.c.getResponse();
                        if (ret == null || ret.length() <= 0) continue;
                        if (!this.containsFilter(ret)) {
                            HTTPWithFileNameCollectorIterable.this.queue.offer(this.addFilePath(ret, url, url.endsWith(".json")), HTTPWithFileNameCollectorIterable.this.waitTime, TimeUnit.SECONDS);
                        } else {
                            ++HTTPWithFileNameCollectorIterable.this.filtered;
                        }
                        ++HTTPWithFileNameCollectorIterable.this.total;
                    }
                    catch (InterruptedException e) {
                        log.info((Object)("not inserted in queue element associate to url " + url + " error: " + e.getMessage()));
                    }
                    continue;
                }
                url = (String)HTTPWithFileNameCollectorIterable.this.urls.remove(0);
                try {
                    this.c.get(url);
                }
                catch (CollectorServiceException e) {
                    log.info((Object)("Impossible to collect url: " + url + " error: " + e.getMessage()));
                }
                if (!this.c.isStatusOk()) continue;
                if (this.c.responseTypeContains(HTTPWithFileNameCollectorIterable.TEXT_HTML)) {
                    this.recurFolder(this.c.getResponse(), url);
                    continue;
                }
                if (!this.c.responseTypeContains(HTTPWithFileNameCollectorIterable.APP_JSON) && !this.c.responseTypeContains(HTTPWithFileNameCollectorIterable.APP_XML)) continue;
                try {
                    String element = this.addFilePath(this.c.getResponse(), url, this.c.responseTypeContains(HTTPWithFileNameCollectorIterable.APP_JSON));
                    HTTPWithFileNameCollectorIterable.this.queue.offer(element, HTTPWithFileNameCollectorIterable.this.waitTime, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.info((Object)("not inserted in queue element associate to url " + url + " error: " + e.getMessage()));
                }
            }
            try {
                HTTPWithFileNameCollectorIterable.this.queue.offer(HTTPWithFileNameCollectorIterable.TERMINATOR, HTTPWithFileNameCollectorIterable.this.waitTime, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(String.format("could not add element to queue for more than %s%s", new Object[]{HTTPWithFileNameCollectorIterable.this.waitTime, TimeUnit.SECONDS}), e);
            }
        }

        private boolean containsFilter(String meta) {
            String[] filter;
            if (HTTPWithFileNameCollectorIterable.this.filterParam == null || HTTPWithFileNameCollectorIterable.this.filterParam.isEmpty()) {
                return false;
            }
            for (String item : filter = HTTPWithFileNameCollectorIterable.this.filterParam.split(";")) {
                if (!meta.contains(item)) continue;
                return true;
            }
            return false;
        }

        private String addFilePath(String meta, String url, boolean isJson) {
            String path = url.replace("metadata", "pdf");
            try {
                if (isJson) {
                    meta = meta.substring(0, meta.length() - 1) + ",'downloadFileUrl':'" + path.substring(0, path.indexOf(".json")) + ".pdf'}";
                } else {
                    if (meta.contains("<!DOCTYPE")) {
                        meta = meta.substring(meta.indexOf("<!DOCTYPE"));
                        meta = meta.substring(meta.indexOf(">") + 1);
                    }
                    int index = meta.lastIndexOf("</");
                    meta = meta.substring(0, index) + "<downloadFileUrl>" + path.substring(0, path.indexOf(".xml")) + ".pdf</downloadFileUrl>" + meta.substring(index);
                }
            }
            catch (Exception ex) {
                log.info((Object)"not file with extension .json or .xml");
            }
            if (isJson) {
                try {
                    return XML.toString((Object)new JSONObject("{'resource':" + meta + "}"));
                }
                catch (Exception e) {
                    log.fatal((Object)("Impossible to transform json object to xml \n" + meta + "\n " + e.getMessage() + "\n" + url));
                    String junk = String.format(HTTPWithFileNameCollectorIterable.JUNK, url);
                    log.warn((Object)("returning " + junk));
                    return junk;
                }
            }
            return meta;
        }

        private void recurFolder(String text, String url) {
            Document doc = Jsoup.parse((String)text);
            Elements links = doc.select("a");
            for (Element e : links) {
                if (e.text().equals("../")) continue;
                String file = e.attr("href");
                if (file.endsWith(".json") || file.endsWith(".xml")) {
                    HTTPWithFileNameCollectorIterable.this.metas.add(url + file);
                    continue;
                }
                HTTPWithFileNameCollectorIterable.this.urls.add(url + file);
            }
        }

        @Override
        public void run() {
            this.fillQueue();
        }
    }
}

