/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.projects.gtr2;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.collector.plugins.projects.gtr2.Gtr2Helper;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.CollectorServiceRuntimeException;
import eu.dnetlib.enabling.resultset.SizedIterable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class Gtr2ProjectsIterable
implements SizedIterable<String> {
    public static final String TERMINATOR = "ARNOLD";
    public static final int WAIT_END_SECONDS = 120;
    public static final int PAGE_SZIE = 20;
    private static final Log log = LogFactory.getLog(Gtr2ProjectsIterable.class);
    private String queryURL;
    private int total = -1;
    private int startFromPage = 1;
    private int endAtPage;
    private VTDGen vg;
    private VTDNav vn;
    private AutoPilot ap;
    private String namespaces;
    private boolean incremental = false;
    private DateTime fromDate;
    private DateTimeFormatter simpleDateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private ArrayBlockingQueue<String> projects = new ArrayBlockingQueue(20);
    private final ExecutorService es = Executors.newFixedThreadPool(20);
    private String nextElement = null;

    public Gtr2ProjectsIterable(String baseUrl, String fromDate) throws CollectorServiceException {
        this.prepare(baseUrl, fromDate);
        this.fillInfo(true);
    }

    public Gtr2ProjectsIterable(String baseUrl, String fromDate, int startFromPage, int endAtPage) throws CollectorServiceException {
        this.prepare(baseUrl, fromDate);
        this.setStartFromPage(startFromPage);
        this.setEndAtPage(endAtPage);
        this.fillInfo(false);
    }

    private void prepare(String baseUrl, String fromDate) {
        this.queryURL = baseUrl + "/projects";
        this.vg = new VTDGen();
        this.incremental = StringUtils.isNotBlank((CharSequence)fromDate);
        if (this.incremental) {
            this.fromDate = DateTime.parse((String)fromDate, (DateTimeFormatter)this.simpleDateTimeFormatter);
            log.debug((Object)("fromDate string: " + fromDate + " -- parsed: " + this.fromDate.toString()));
        }
    }

    public int getNumberOfElements() {
        return this.total;
    }

    private void fillInfo(boolean all) throws CollectorServiceException {
        try {
            this.vg.parseHttpUrl(this.queryURL, false);
            this.initParser();
            String hitCount = this.vn.toNormalizedString(this.vn.getAttrVal("totalSize"));
            String totalPages = this.vn.toNormalizedString(this.vn.getAttrVal("totalPages"));
            this.namespaces = "xmlns:ns1=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns1")) + "\" ";
            this.namespaces = this.namespaces + "xmlns:ns2=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns2")) + "\" ";
            this.namespaces = this.namespaces + "xmlns:ns3=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns3")) + "\" ";
            this.namespaces = this.namespaces + "xmlns:ns4=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns4")) + "\" ";
            this.namespaces = this.namespaces + "xmlns:ns5=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns5")) + "\" ";
            this.namespaces = this.namespaces + "xmlns:ns6=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns6")) + "\" ";
            if (all) {
                this.setEndAtPage(Integer.parseInt(totalPages));
                this.total = Integer.parseInt(hitCount);
            }
            Thread ft = new Thread(new FillProjectList());
            ft.start();
            log.debug((Object)("Expected number of pages: " + (this.endAtPage - this.startFromPage + 1)));
        }
        catch (NumberFormatException e) {
            log.error((Object)"Cannot set the total count or the number of pages");
            throw new CollectorServiceException((Throwable)e);
        }
        catch (Throwable e) {
            throw new CollectorServiceException(e);
        }
    }

    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int nextCounter = 0;

            @Override
            public boolean hasNext() {
                try {
                    log.debug((Object)"hasNext?");
                    if (Gtr2ProjectsIterable.this.nextElement == null) {
                        Gtr2ProjectsIterable.this.nextElement = (String)Gtr2ProjectsIterable.this.projects.poll(120L, TimeUnit.SECONDS);
                        log.debug((Object)"Exit poll :-)");
                    }
                    return Gtr2ProjectsIterable.this.nextElement != null && !Gtr2ProjectsIterable.this.nextElement.equals(Gtr2ProjectsIterable.TERMINATOR);
                }
                catch (InterruptedException e) {
                    throw new CollectorServiceRuntimeException((Throwable)e);
                }
            }

            @Override
            public String next() {
                ++this.nextCounter;
                log.debug((Object)String.format("Calling next %s times.", this.nextCounter));
                if (Gtr2ProjectsIterable.this.nextElement == null) {
                    throw new NoSuchElementException();
                }
                String res = Gtr2ProjectsIterable.this.nextElement;
                Gtr2ProjectsIterable.this.nextElement = null;
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void initParser() {
        this.vn = this.vg.getNav();
        this.ap = new AutoPilot(this.vn);
    }

    public String getQueryURL() {
        return this.queryURL;
    }

    public void setQueryURL(String queryURL) {
        this.queryURL = queryURL;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getEndAtPage() {
        return this.endAtPage;
    }

    public void setEndAtPage(int endAtPage) {
        this.endAtPage = endAtPage;
        log.debug((Object)("Overriding endAtPage to " + endAtPage));
    }

    public VTDGen getVg() {
        return this.vg;
    }

    public void setVg(VTDGen vg) {
        this.vg = vg;
    }

    public VTDNav getVn() {
        return this.vn;
    }

    public void setVn(VTDNav vn) {
        this.vn = vn;
    }

    public AutoPilot getAp() {
        return this.ap;
    }

    public void setAp(AutoPilot ap) {
        this.ap = ap;
    }

    public String getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(String namespaces) {
        this.namespaces = namespaces;
    }

    public int getStartFromPage() {
        return this.startFromPage;
    }

    public void setStartFromPage(int startFromPage) {
        this.startFromPage = startFromPage;
        log.debug((Object)("Overriding startFromPage to " + startFromPage));
    }

    static /* synthetic */ int access$400(Gtr2ProjectsIterable x0) {
        return x0.startFromPage;
    }

    private class ParseProject
    implements Runnable {
        VTDNav vn1;
        VTDGen vg1;
        private String projectRef;

        public ParseProject(String projectHref) {
            this.projectRef = projectHref;
            this.vg1 = new VTDGen();
            this.vg1.parseHttpUrl(this.projectRef, false);
            this.vn1 = this.vg1.getNav();
        }

        private int projectsUpdate(String attr) throws CollectorServiceException {
            try {
                int index = this.vn1.getAttrVal(attr);
                if (index != -1) {
                    String d = this.vn1.toNormalizedString(index);
                    DateTime recordDate = DateTime.parse((String)d.substring(0, d.indexOf("T")), (DateTimeFormatter)Gtr2ProjectsIterable.this.simpleDateTimeFormatter);
                    if (recordDate.isAfter((ReadableInstant)Gtr2ProjectsIterable.this.fromDate)) {
                        log.debug((Object)"New project to collect");
                        return index;
                    }
                    return -1;
                }
                return index;
            }
            catch (Throwable e) {
                throw new CollectorServiceException(e);
            }
        }

        private String collectProject() throws CollectorServiceException {
            try {
                int p = this.vn1.getAttrVal("href");
                String projectHref = this.vn1.toNormalizedString(p);
                log.debug((Object)("collecting project at " + projectHref));
                Gtr2Helper gtr2Helper = new Gtr2Helper();
                String projectPackage = gtr2Helper.processProject(this.vn1, Gtr2ProjectsIterable.this.namespaces);
                return projectPackage;
            }
            catch (Throwable e) {
                throw new CollectorServiceException(e);
            }
        }

        private boolean add(String attr) throws CollectorServiceException {
            return this.projectsUpdate(attr) != -1;
        }

        @Override
        public void run() {
            log.debug((Object)("Getting project info from " + this.projectRef));
            try {
                if (!Gtr2ProjectsIterable.this.incremental || Gtr2ProjectsIterable.this.incremental && (this.add("created") || this.add("updated"))) {
                    Gtr2ProjectsIterable.this.projects.put(this.collectProject());
                    log.debug((Object)("Project enqueued " + this.projectRef));
                }
            }
            catch (Throwable e) {
                log.error((Object)("Error on ParseProject " + e.getMessage()));
                throw new CollectorServiceRuntimeException(e);
            }
        }
    }

    private class FillProjectList
    implements Runnable {
        private boolean morePages = true;
        private int pageNumber = Gtr2ProjectsIterable.access$400(Gtr2ProjectsIterable.this);

        private FillProjectList() {
        }

        @Override
        public void run() {
            String resultPageUrl = "";
            try {
                do {
                    int res;
                    resultPageUrl = this.getNextPageUrl();
                    log.debug((Object)("Page: " + resultPageUrl));
                    Gtr2ProjectsIterable.this.vg.clear();
                    Gtr2ProjectsIterable.this.vg.parseHttpUrl(resultPageUrl, false);
                    Gtr2ProjectsIterable.this.initParser();
                    Gtr2ProjectsIterable.this.ap.selectXPath("//project");
                    while ((res = Gtr2ProjectsIterable.this.ap.evalXPath()) != -1) {
                        String projectHref = Gtr2ProjectsIterable.this.vn.toNormalizedString(Gtr2ProjectsIterable.this.vn.getAttrVal("href"));
                        Thread t = new Thread(new ParseProject(projectHref));
                        t.setName("Thread for " + res);
                        Gtr2ProjectsIterable.this.es.execute(t);
                    }
                    Gtr2ProjectsIterable.this.ap.resetXPath();
                } while (this.morePages);
                Gtr2ProjectsIterable.this.es.shutdown();
                Gtr2ProjectsIterable.this.es.awaitTermination(120L, TimeUnit.SECONDS);
                Gtr2ProjectsIterable.this.projects.put(Gtr2ProjectsIterable.TERMINATOR);
            }
            catch (Throwable e) {
                log.error((Object)("Exception processing " + resultPageUrl + "\n" + e.getMessage()));
            }
        }

        private String getNextPageUrl() {
            String url = Gtr2ProjectsIterable.this.queryURL + "?p=" + this.pageNumber;
            if (this.pageNumber == Gtr2ProjectsIterable.this.endAtPage) {
                this.morePages = false;
            }
            ++this.pageNumber;
            return url;
        }
    }
}

