//package eu.dnetlib.data.collector.plugins.schemaorg;
//
//import eu.dnetlib.data.collector.plugins.schemaorg.sitemapindex.SitemapFileIterator;
//import eu.dnetlib.data.collector.plugins.schemaorg.sitemapindex.SitemapIndexIterator;
//import org.apache.commons.logging.Log;
//import org.apache.commons.logging.LogFactory;
//
//import java.net.URL;
//import java.util.Iterator;
//import java.util.concurrent.ArrayBlockingQueue;
//import java.util.concurrent.ExecutorService;
//import java.util.concurrent.Executors;
//
//public class SchemaOrgIterableOLD implements Iterable<String> {
//	private static final Log log = LogFactory.getLog(SchemaOrgIterable.class);
//
//	public static class Options {
//		private SchemaOrgIterator.Options schemaOrgIteratorOptions;
//		private SitemapIndexIterator.Options sitemapIndexIteratorOptions;
//		private SitemapFileIterator.Options sitemapFileIteratorOptions;
//		private EndpointAccessIterator.Options endpointAccessIteratorOptions;
//		private DatasetMappingIterator.Options datasetMappingIteratorOptions;
//
//		private int queueSize;
//
//		public DatasetMappingIterator.Options getDatasetMappingIteratorOptions() {
//			return datasetMappingIteratorOptions;
//		}
//
//		public void setDatasetMappingIteratorOptions(DatasetMappingIterator.Options datasetMappingIteratorOptions) {
//			this.datasetMappingIteratorOptions = datasetMappingIteratorOptions;
//		}
//
//		public EndpointAccessIterator.Options getEndpointAccessIteratorOptions() {
//			return endpointAccessIteratorOptions;
//		}
//
//		public void setEndpointAccessIteratorOptions(EndpointAccessIterator.Options endpointAccessIteratorOptions) {
//			this.endpointAccessIteratorOptions = endpointAccessIteratorOptions;
//		}
//
//		public SitemapFileIterator.Options getSitemapFileIteratorOptions() {
//			return sitemapFileIteratorOptions;
//		}
//
//		public void setSitemapFileIteratorOptions(SitemapFileIterator.Options sitemapFileIteratorOptions) {
//			this.sitemapFileIteratorOptions = sitemapFileIteratorOptions;
//		}
//
//		public SitemapIndexIterator.Options getSitemapIndexIteratorOptions() {
//			return sitemapIndexIteratorOptions;
//		}
//
//		public void setSitemapIndexIteratorOptions(SitemapIndexIterator.Options sitemapIndexIteratorOptions) {
//			this.sitemapIndexIteratorOptions = sitemapIndexIteratorOptions;
//		}
//
//		public SchemaOrgIterator.Options getSchemaOrgIteratorOptions() {
//			return schemaOrgIteratorOptions;
//		}
//
//		public void setSchemaOrgIteratorOptions(SchemaOrgIterator.Options schemaOrgIteratorOptions) {
//			this.schemaOrgIteratorOptions = schemaOrgIteratorOptions;
//		}
//
//		public int getQueueSize() {
//			return queueSize;
//		}
//
//		public void setQueueSize(int queueSize) {
//			this.queueSize = queueSize;
//		}
//	}
//
//	private Options options;
//	private ArrayBlockingQueue<String> queue;
//
//	public SchemaOrgIterable(Options options) {
//		this.options = options;
//		this.queue = new ArrayBlockingQueue<>(this.options.getQueueSize(), true);
//	}
//
//	public void bootstrap() {
//		ExecutorService executor = Executors.newSingleThreadExecutor();
//		executor.execute(new Harvester());
//		executor.shutdown();
//	}
//
//	@Override
//	public Iterator<String> iterator() {
//		return new SchemaOrgIterator(this.options.getSchemaOrgIteratorOptions(), this.queue);
//	}
//
//	private class Harvester implements Runnable{
//
//		@Override
//		public void run() {
//			this.execute();
//		}
//
//		private void execute(){
//			try {
//				SitemapIndexIterator sitemapIndexIterator = new SitemapIndexIterator(options.getSitemapIndexIteratorOptions());
//				sitemapIndexIterator.bootstrap();
//
//				while (sitemapIndexIterator.hasNext()) {
//					String sitemapFile = sitemapIndexIterator.next();
//					if(sitemapFile == null) continue;
//
//					SitemapFileIterator.Options sitemapFileIteratorOptions = (SitemapFileIterator.Options)options.getSitemapFileIteratorOptions().clone();
//					sitemapFileIteratorOptions.setFileUrl(new URL(sitemapFile));
//					SitemapFileIterator sitemapFileIterator = new SitemapFileIterator(sitemapFileIteratorOptions);
//					sitemapFileIterator.bootstrap();
//
//					EndpointAccessIterator endpointAccessIterator = new EndpointAccessIterator(options.getEndpointAccessIteratorOptions(), sitemapFileIterator);
//					DatasetMappingIterator datasetMappingIterator = new DatasetMappingIterator(options.getDatasetMappingIteratorOptions(), endpointAccessIterator);
//
//					while (datasetMappingIterator.hasNext()) {
//						String xml = datasetMappingIterator.next();
//						if(xml == null) continue;
//
//						queue.put(xml);
//					}
//				}
//			}catch(Exception ex){
//				log.error("problem execution harvesting", ex);
//			}
//			finally {
//				try {
//					queue.put(Conventions.TerminateHint);
//				} catch (Exception ex) {
//					log.fatal("could not add termination hint. the process will not terminate gracefully", ex);
//				}
//			}
//		}
//	}
//}
