/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.schemaorg;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryQueueIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(RepositoryQueueIterator.class);
    private ArrayBlockingQueue<String> queue;
    private Options options;
    private boolean hasTerminated;

    public RepositoryQueueIterator(Options options, ArrayBlockingQueue<String> queue) {
        this.options = options;
        this.queue = queue;
        this.hasTerminated = false;
    }

    @Override
    public boolean hasNext() {
        return !this.hasTerminated;
    }

    @Override
    public String next() {
        String next = this.poll();
        if (next != null && next.equalsIgnoreCase("df667391-676d-4c0f-9c40-426b1001607a")) {
            this.hasTerminated = true;
            next = null;
        }
        return next;
    }

    private String poll() {
        if (this.options.getBlockPolling().booleanValue()) {
            try {
                return this.queue.poll(this.options.getPollTimeout(), this.options.getPollTimeoutUnit());
            }
            catch (InterruptedException ex) {
                log.warn((Object)String.format("could not poll elements from queue for more than %s %s. throwing", new Object[]{this.options.getPollTimeout(), this.options.getPollTimeoutUnit()}));
                throw new NoSuchElementException(ex.getMessage());
            }
        }
        return this.queue.poll();
    }

    public static class Options {
        private Boolean blockPolling;
        private long pollTimeout;
        private TimeUnit pollTimeoutUnit;

        public Boolean getBlockPolling() {
            return this.blockPolling;
        }

        public void setBlockPolling(Boolean blockPolling) {
            this.blockPolling = blockPolling;
        }

        public long getPollTimeout() {
            return this.pollTimeout;
        }

        public void setPollTimeout(long pollTimeout) {
            this.pollTimeout = pollTimeout;
        }

        public TimeUnit getPollTimeoutUnit() {
            return this.pollTimeoutUnit;
        }

        public void setPollTimeoutUnit(TimeUnit pollTimeoutUnit) {
            this.pollTimeoutUnit = pollTimeoutUnit;
        }
    }
}

