/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.schemaorg.httpapi.kaggle;

import eu.dnetlib.data.collector.plugins.schemaorg.RepositoryQueueIterator;
import eu.dnetlib.data.collector.plugins.schemaorg.httpapi.HttpApiRepositoryIterable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class KaggleRepositoryIterable
implements HttpApiRepositoryIterable {
    private static final Log log = LogFactory.getLog(KaggleRepositoryIterable.class);
    private Options options;
    private ArrayBlockingQueue<String> queue;

    public KaggleRepositoryIterable(Options options) {
        this.options = options;
    }

    public void bootstrap() {
        this.queue = new ArrayBlockingQueue(this.options.getQueueSize(), true);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Harvester());
        executor.shutdown();
    }

    @Override
    public Iterator<String> iterator() {
        return new RepositoryQueueIterator(this.options.getRepositoryQueueIteratorOptions(), this.queue);
    }

    private class Harvester
    implements Runnable {
        private Harvester() {
        }

        @Override
        public void run() {
            this.execute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute() {
            try {
                int currentPage = 1;
                int totalDatasets = 0;
                int readDatasets = 0;
                do {
                    String query = KaggleRepositoryIterable.this.options.getQueryUrl().replace(KaggleRepositoryIterable.this.options.getQueryPagePlaceholder(), Integer.toString(currentPage));
                    String response = IOUtils.toString((URL)new URL(query), (Charset)KaggleRepositoryIterable.this.options.getCharset());
                    ++currentPage;
                    JSONObject pageObject = new JSONObject(response);
                    totalDatasets = pageObject.optInt(KaggleRepositoryIterable.this.options.getResponsePropertyTotalDataset());
                    JSONArray datasets = pageObject.optJSONArray(KaggleRepositoryIterable.this.options.getResponsePropertyDatasetList());
                    if (datasets == null) break;
                    if (datasets.length() == 0) {
                        break;
                    }
                    readDatasets += datasets.length();
                    for (int i = 0; i < datasets.length(); ++i) {
                        JSONObject item = datasets.optJSONObject(i);
                        String urlFragment = item.optString(KaggleRepositoryIterable.this.options.getResponsePropertyDatasetUrl());
                        if (urlFragment == null || urlFragment.trim().length() == 0) continue;
                        String endpoint = String.format("%s%s", KaggleRepositoryIterable.this.options.getResponseBaseDatasetUrl(), urlFragment);
                        KaggleRepositoryIterable.this.queue.put(endpoint);
                    }
                } while (readDatasets < totalDatasets);
            }
            catch (Exception ex) {
                log.error((Object)"problem execution harvesting", (Throwable)ex);
            }
            finally {
                try {
                    KaggleRepositoryIterable.this.queue.put("df667391-676d-4c0f-9c40-426b1001607a");
                }
                catch (Exception ex) {
                    log.fatal((Object)"could not add termination hint. the process will not terminate gracefully", (Throwable)ex);
                }
            }
        }
    }

    public static class Options {
        private String queryUrl;
        private String queryPagePlaceholder;
        private Charset charset;
        private String responsePropertyTotalDataset;
        private String responsePropertyDatasetList;
        private String responsePropertyDatasetUrl;
        private String responseBaseDatasetUrl;
        private RepositoryQueueIterator.Options repositoryQueueIteratorOptions;
        private int queueSize;

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }

        public String getResponseBaseDatasetUrl() {
            return this.responseBaseDatasetUrl;
        }

        public void setResponseBaseDatasetUrl(String responseBaseDatasetUrl) {
            this.responseBaseDatasetUrl = responseBaseDatasetUrl;
        }

        public RepositoryQueueIterator.Options getRepositoryQueueIteratorOptions() {
            return this.repositoryQueueIteratorOptions;
        }

        public void setRepositoryQueueIteratorOptions(RepositoryQueueIterator.Options repositoryQueueIteratorOptions) {
            this.repositoryQueueIteratorOptions = repositoryQueueIteratorOptions;
        }

        public String getResponsePropertyDatasetUrl() {
            return this.responsePropertyDatasetUrl;
        }

        public void setResponsePropertyDatasetUrl(String responsePropertyDatasetUrl) {
            this.responsePropertyDatasetUrl = responsePropertyDatasetUrl;
        }

        public String getResponsePropertyDatasetList() {
            return this.responsePropertyDatasetList;
        }

        public void setResponsePropertyDatasetList(String responsePropertyDatasetList) {
            this.responsePropertyDatasetList = responsePropertyDatasetList;
        }

        public String getResponsePropertyTotalDataset() {
            return this.responsePropertyTotalDataset;
        }

        public void setResponsePropertyTotalDataset(String responsePropertyTotalDataset) {
            this.responsePropertyTotalDataset = responsePropertyTotalDataset;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        public String getQueryPagePlaceholder() {
            return this.queryPagePlaceholder;
        }

        public void setQueryPagePlaceholder(String queryPagePlaceholder) {
            this.queryPagePlaceholder = queryPagePlaceholder;
        }

        public String getQueryUrl() {
            return this.queryUrl;
        }

        public void setQueryUrl(String queryUrl) {
            this.queryUrl = queryUrl;
        }
    }
}

