/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.httpfilename;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpWithFileNameCollectorIterator
implements Iterator<String> {
    public static final String TERMINATOR = "FINITO";
    private static final Log log = LogFactory.getLog(HttpWithFileNameCollectorIterator.class);
    private final ArrayBlockingQueue<String> queue;
    public static final long waitTime = 60L;
    private String last = "<resource><DOI>JUNK</DOI></resource>";

    public HttpWithFileNameCollectorIterator(ArrayBlockingQueue<String> queue) {
        this.queue = queue;
        this.extractFromQueue();
    }

    @Override
    public boolean hasNext() {
        return !Objects.equals(this.last, TERMINATOR) && !Objects.equals(this.last, null);
    }

    @Override
    public String next() {
        try {
            String string = this.last;
            return string;
        }
        finally {
            this.extractFromQueue();
        }
    }

    private void extractFromQueue() {
        try {
            this.last = this.queue.poll(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn((Object)String.format("could not find elements to consume for more than %s%s", new Object[]{60L, TimeUnit.SECONDS}));
            throw new NoSuchElementException(e.getMessage());
        }
    }
}

