/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.rest;

import eu.dnetlib.data.collector.plugins.oai.OaiIterator;
import eu.dnetlib.data.collector.plugins.oai.engine.XmlCleaner;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RestIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(OaiIterator.class);
    private static final String wrapName = "recordWrap";
    private String baseUrl;
    private String resumptionType;
    private String resumptionParam;
    private String resultFormatValue;
    private String queryParams;
    private int resultSizeValue;
    private int resumptionInt = 0;
    private int resultTotal = -1;
    private String resumptionStr = Integer.toString(this.resumptionInt);
    private InputStream resultStream;
    private Transformer transformer;
    private XPath xpath;
    private String query;
    private XPathExpression xprResultTotalPath;
    private XPathExpression xprResumptionPath;
    private XPathExpression xprEntity;
    private String queryFormat;
    private String querySize;
    private Queue<String> recordQueue = new PriorityBlockingQueue<String>();
    private int discoverResultSize = 0;
    private int pagination = 1;

    public RestIterator(String baseUrl, String resumptionType, String resumptionParam, String resumptionXpath, String resultTotalXpath, String resultFormatParam, String resultFormatValue, String resultSizeParam, String resultSizeValueStr, String queryParams, String entityXpath) {
        this.baseUrl = baseUrl;
        this.resumptionType = resumptionType;
        this.resumptionParam = resumptionParam;
        this.resultFormatValue = resultFormatValue;
        this.queryParams = queryParams;
        this.resultSizeValue = Integer.valueOf(resultSizeValueStr);
        this.queryFormat = StringUtils.isNotBlank((CharSequence)resultFormatParam) ? "&" + resultFormatParam + "=" + resultFormatValue : "";
        this.querySize = StringUtils.isNotBlank((CharSequence)resultSizeParam) ? "&" + resultSizeParam + "=" + resultSizeValueStr : "";
        try {
            this.initXmlTransformation(resultTotalXpath, resumptionXpath, entityXpath);
        }
        catch (Exception e) {
            throw new IllegalStateException("xml transformation init failed: " + e.getMessage());
        }
        this.initQueue();
    }

    private void initXmlTransformation(String resultTotalXpath, String resumptionXpath, String entityXpath) throws TransformerConfigurationException, XPathExpressionException {
        this.transformer = TransformerFactory.newInstance().newTransformer();
        this.transformer.setOutputProperty("indent", "yes");
        this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        this.xpath = XPathFactory.newInstance().newXPath();
        this.xprResultTotalPath = this.xpath.compile(resultTotalXpath);
        this.xprResumptionPath = this.xpath.compile(StringUtils.isBlank((CharSequence)resumptionXpath) ? "/" : resumptionXpath);
        this.xprEntity = this.xpath.compile(entityXpath);
    }

    private void initQueue() {
        this.query = this.baseUrl + "?" + this.queryParams + this.querySize + this.queryFormat;
    }

    private void disconnect() {
    }

    @Override
    public boolean hasNext() {
        if (this.recordQueue.isEmpty() && this.query.isEmpty()) {
            this.disconnect();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        Queue<String> queue = this.recordQueue;
        synchronized (queue) {
            while (this.recordQueue.isEmpty() && !this.query.isEmpty()) {
                try {
                    log.info((Object)("get Query: " + this.query));
                    this.query = this.downloadPage(this.query);
                    log.debug((Object)("next queryURL from downloadPage(): " + this.query));
                }
                catch (CollectorServiceException e) {
                    log.debug((Object)("CollectorPlugin.next()-Exception: " + (Object)((Object)e)));
                    throw new RuntimeException(e);
                }
            }
            return this.recordQueue.poll();
        }
    }

    private String downloadPage(String query) throws CollectorServiceException {
        String resultXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        String nextQuery = "";
        String emptyXml = resultXml + "<" + wrapName + "></" + wrapName + ">";
        Node resultNode = null;
        NodeList nodeList = null;
        String qUrlArgument = "";
        int urlOldResumptionSize = 0;
        try {
            URL qUrl = new URL(query);
            this.resultStream = qUrl.openStream();
            if ("json".equals(this.resultFormatValue.toLowerCase())) {
                String resultJson = IOUtils.toString((InputStream)this.resultStream, (String)"UTF-8");
                resultJson = this.syntaxConvertJsonKeyNamens(resultJson);
                JSONObject jsonObject = new JSONObject(resultJson);
                resultXml = resultXml + XML.toString((Object)jsonObject, (String)wrapName);
                log.trace((Object)("before inputStream: " + resultXml));
                resultXml = XmlCleaner.cleanAllEntities((String)resultXml);
                log.trace((Object)("after cleaning: " + resultXml));
                this.resultStream = IOUtils.toInputStream((String)resultXml, (String)"UTF-8");
            }
            if (!emptyXml.toLowerCase().equals(resultXml.toLowerCase())) {
                resultNode = (Node)this.xpath.evaluate("/", new InputSource(this.resultStream), XPathConstants.NODE);
                nodeList = (NodeList)this.xprEntity.evaluate(resultNode, XPathConstants.NODESET);
                log.debug((Object)("nodeList.length: " + nodeList.getLength()));
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    StringWriter sw = new StringWriter();
                    this.transformer.transform(new DOMSource(nodeList.item(i)), new StreamResult(sw));
                    this.recordQueue.add(sw.toString());
                }
            } else {
                log.info((Object)"resultXml is equal with emptyXml");
            }
            this.resumptionInt += this.resultSizeValue;
            switch (this.resumptionType.toLowerCase()) {
                case "scan": {
                    this.resumptionStr = this.xprResumptionPath.evaluate(resultNode);
                    break;
                }
                case "count": {
                    this.resumptionStr = Integer.toString(this.resumptionInt);
                    break;
                }
                case "discover": {
                    String[] arrayQUrlArgument;
                    if (this.resultSizeValue < 2) {
                        throw new CollectorServiceException("Mode: discover, Param 'resultSizeValue' is less than 2");
                    }
                    qUrlArgument = qUrl.getQuery();
                    for (String arrayUrlArgStr : arrayQUrlArgument = qUrlArgument.split("&")) {
                        if (!arrayUrlArgStr.startsWith(this.resumptionParam)) continue;
                        String[] resumptionKeyValue = arrayUrlArgStr.split("=");
                        urlOldResumptionSize = Integer.parseInt(resumptionKeyValue[1]);
                        log.debug((Object)("discover OldResumptionSize from Url: " + urlOldResumptionSize));
                    }
                    if (emptyXml.toLowerCase().equals(resultXml.toLowerCase()) || nodeList != null && nodeList.getLength() < this.resultSizeValue) {
                        if (nodeList != null) {
                            this.discoverResultSize += nodeList.getLength();
                        }
                        this.resultTotal = this.discoverResultSize;
                    } else {
                        this.resumptionStr = Integer.toString(this.resumptionInt);
                        this.resultTotal = this.resumptionInt + 1;
                        if (nodeList != null) {
                            this.discoverResultSize += nodeList.getLength();
                        }
                    }
                    log.info((Object)("discoverResultSize:  " + this.discoverResultSize));
                    break;
                }
                case "pagination": 
                case "page": {
                    ++this.pagination;
                    if (nodeList != null) {
                        this.discoverResultSize += nodeList.getLength();
                    } else {
                        this.resultTotal = this.discoverResultSize;
                        this.pagination = this.discoverResultSize;
                    }
                    this.resumptionInt = this.pagination;
                    this.resumptionStr = Integer.toString(this.resumptionInt);
                    break;
                }
            }
            if (this.resultTotal == -1) {
                this.resultTotal = Integer.parseInt(this.xprResultTotalPath.evaluate(resultNode));
                log.info((Object)("resultTotal was -1 is now: " + this.resultTotal));
            }
            log.info((Object)("resultTotal: " + this.resultTotal));
            log.info((Object)("resInt: " + this.resumptionInt));
            nextQuery = this.resumptionInt < this.resultTotal ? this.baseUrl + "?" + this.queryParams + this.querySize + "&" + this.resumptionParam + "=" + this.resumptionStr + this.queryFormat : "";
            log.debug((Object)("nextQueryUrl: " + nextQuery));
            return nextQuery;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IllegalStateException("collection failed: " + e.getMessage());
        }
    }

    private String syntaxConvertJsonKeyNamens(String jsonInput) {
        log.trace((Object)("before convertJsonKeyNames: " + jsonInput));
        while (jsonInput.matches(".*\"([^\"]*)\\s+([^\"]*)\":.*")) {
            jsonInput = jsonInput.replaceAll("\"([^\"]*)\\s+([^\"]*)\":", "\"$1_$2\":");
        }
        while (jsonInput.matches(".*\"([^\"]*)/([^\"]*)\":.*")) {
            jsonInput = jsonInput.replaceAll("\"([^\"]*)/([^\"]*)\":", "\"$1_$2\":");
        }
        while (jsonInput.matches(".*\"([^\"]*)[(]([^\"]*)\":.*")) {
            jsonInput = jsonInput.replaceAll("\"([^\"]*)[(]([^\"]*)\":", "\"$1$2\":");
        }
        while (jsonInput.matches(".*\"([^\"]*)[)]([^\"]*)\":.*")) {
            jsonInput = jsonInput.replaceAll("\"([^\"]*)[)]([^\"]*)\":", "\"$1$2\":");
        }
        while (jsonInput.matches(".*\"([^\"][0-9])([^\"]*)\":.*")) {
            jsonInput = jsonInput.replaceAll("\"([^\"][0-9])([^\"]*)\":", "\"n_$1$2\":");
        }
        while (jsonInput.matches(".*\"([^\"]*[0-9]):([0-9][^\"]*)\":.*")) {
            jsonInput = jsonInput.replaceAll("\"([^\"]*[0-9]):([0-9][^\"]*)\":", "\"$1$2\":");
        }
        while (jsonInput.matches(".*\"([^\"]*)=([^\"]*)\":.*")) {
            jsonInput = jsonInput.replaceAll("\"([^\"]*)=([^\"]*)\":", "\"$1-$2\":");
        }
        log.trace((Object)("after syntaxConvertJsonKeyNames: " + jsonInput));
        return jsonInput;
    }

    private static String cleanUnwantedJsonCharsInXmlTagnames(String bufferStr) {
        while (bufferStr.matches(".*<([^<>].*),(.)>.*")) {
            bufferStr = bufferStr.replaceAll("<([^<>.*),(.*)>", "<$1$2>");
        }
        return bufferStr;
    }
}

