/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.schemaorg.sitemapindex;

import eu.dnetlib.data.collector.plugins.schemaorg.RepositoryIterable;
import eu.dnetlib.data.collector.plugins.schemaorg.RepositoryQueueIterator;
import eu.dnetlib.data.collector.plugins.schemaorg.sitemapindex.SitemapFileIterator;
import eu.dnetlib.data.collector.plugins.schemaorg.sitemapindex.SitemapIndexIterator;
import java.net.URL;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SitemapIndexRepositoryIterable
implements RepositoryIterable {
    private static final Log log = LogFactory.getLog(SitemapIndexRepositoryIterable.class);
    private Options options;
    private ArrayBlockingQueue<String> queue;

    public SitemapIndexRepositoryIterable(Options options) {
        this.options = options;
    }

    public void bootstrap() {
        this.queue = new ArrayBlockingQueue(this.options.getQueueSize(), true);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Harvester());
        executor.shutdown();
    }

    @Override
    public Iterator<String> iterator() {
        return new RepositoryQueueIterator(this.options.getRepositoryQueueIteratorOptions(), this.queue);
    }

    private class Harvester
    implements Runnable {
        private Harvester() {
        }

        @Override
        public void run() {
            this.execute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute() {
            try {
                SitemapIndexIterator sitemapIndexIterator = new SitemapIndexIterator(SitemapIndexRepositoryIterable.this.options.getSitemapIndexIteratorOptions());
                sitemapIndexIterator.bootstrap();
                while (sitemapIndexIterator.hasNext()) {
                    String sitemapFile = sitemapIndexIterator.next();
                    if (sitemapFile == null) continue;
                    SitemapFileIterator.Options sitemapFileIteratorOptions = (SitemapFileIterator.Options)SitemapIndexRepositoryIterable.this.options.getSitemapFileIteratorOptions().clone();
                    sitemapFileIteratorOptions.setFileUrl(new URL(sitemapFile));
                    SitemapFileIterator sitemapFileIterator = new SitemapFileIterator(sitemapFileIteratorOptions);
                    sitemapFileIterator.bootstrap();
                    while (sitemapFileIterator.hasNext()) {
                        String endpoint = sitemapFileIterator.next();
                        if (endpoint == null) continue;
                        SitemapIndexRepositoryIterable.this.queue.put(endpoint);
                    }
                }
            }
            catch (Exception ex) {
                log.error((Object)"problem execution harvesting", (Throwable)ex);
            }
            finally {
                try {
                    SitemapIndexRepositoryIterable.this.queue.put("df667391-676d-4c0f-9c40-426b1001607a");
                }
                catch (Exception ex) {
                    log.fatal((Object)"could not add termination hint. the process will not terminate gracefully", (Throwable)ex);
                }
            }
        }
    }

    public static class Options {
        private SitemapIndexIterator.Options sitemapIndexIteratorOptions;
        private SitemapFileIterator.Options sitemapFileIteratorOptions;
        private RepositoryQueueIterator.Options repositoryQueueIteratorOptions;
        private int queueSize;

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }

        public RepositoryQueueIterator.Options getRepositoryQueueIteratorOptions() {
            return this.repositoryQueueIteratorOptions;
        }

        public void setRepositoryQueueIteratorOptions(RepositoryQueueIterator.Options repositoryQueueIteratorOptions) {
            this.repositoryQueueIteratorOptions = repositoryQueueIteratorOptions;
        }

        public SitemapIndexIterator.Options getSitemapIndexIteratorOptions() {
            return this.sitemapIndexIteratorOptions;
        }

        public void setSitemapIndexIteratorOptions(SitemapIndexIterator.Options sitemapIndexIteratorOptions) {
            this.sitemapIndexIteratorOptions = sitemapIndexIteratorOptions;
        }

        public SitemapFileIterator.Options getSitemapFileIteratorOptions() {
            return this.sitemapFileIteratorOptions;
        }

        public void setSitemapFileIteratorOptions(SitemapFileIterator.Options sitemapFileIteratorOptions) {
            this.sitemapFileIteratorOptions = sitemapFileIteratorOptions;
        }
    }
}

