/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.schemaorg.sitemapindex;

import eu.dnetlib.data.collector.plugins.schemaorg.Utils;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SitemapFileIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(SitemapFileIterator.class);
    private Options options;
    private File downloadedFile;
    private File contentFile;
    private Queue<String> locations;

    public SitemapFileIterator(Options options) {
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap() {
        LinkedList<String> endpoints = null;
        try {
            String path = new File(".").getCanonicalPath();
            log.debug((Object)String.format("bootstrapping sitemapindex file access for sitemapindex %s", this.options.getFileUrl()));
            this.downloadedFile = File.createTempFile(UUID.randomUUID().toString(), ".tmp");
            this.downloadedFile.deleteOnExit();
            FileUtils.copyURLToFile((URL)this.options.getFileUrl(), (File)this.downloadedFile);
            log.debug((Object)String.format("downloaded file: %s has size %d", this.downloadedFile.toString(), this.downloadedFile.length()));
            switch (this.options.getFileType()) {
                case Text: {
                    this.contentFile = this.downloadedFile;
                    break;
                }
                case GZ: {
                    this.contentFile = File.createTempFile(UUID.randomUUID().toString(), ".tmp");
                    this.contentFile.deleteOnExit();
                    Utils.decompressGZipTo(this.downloadedFile, this.contentFile);
                    log.debug((Object)String.format("extracted gz file: %s has size %d", this.contentFile.toString(), this.contentFile.length()));
                    break;
                }
                default: {
                    throw new CollectorServiceException("unrecognized file type " + (Object)((Object)this.options.getFileType()));
                }
            }
            List<String> content = this.collectContentLocations();
            log.debug((Object)String.format("extracted %d sitemapindex endpoints", content.size()));
            endpoints = new LinkedList<String>(content);
        }
        catch (Exception ex) {
            log.error((Object)String.format("error processing sitemapindex %s. returning 0 endpoints", this.options.getFileUrl()), (Throwable)ex);
            endpoints = new LinkedList<String>();
        }
        finally {
            if (this.contentFile != null) {
                this.contentFile.delete();
            }
            if (this.downloadedFile != null) {
                this.downloadedFile.delete();
            }
        }
        this.locations = endpoints;
    }

    private List<String> collectContentLocations() throws Exception {
        switch (this.options.getSchemaType()) {
            case Text: {
                return this.collectTextContentLocations();
            }
            case Xml: {
                return this.collectXmlContentLocations();
            }
        }
        throw new CollectorServiceException("unrecognized file type " + (Object)((Object)this.options.getFileType()));
    }

    private List<String> collectTextContentLocations() throws Exception {
        log.debug((Object)String.format("reading endpoint locations from text sitemapindex", new Object[0]));
        try (FileInputStream in = new FileInputStream(this.contentFile);){
            List list = IOUtils.readLines((InputStream)in, (Charset)this.options.getCharset());
            return list;
        }
    }

    private List<String> collectXmlContentLocations() throws Exception {
        log.debug((Object)String.format("reading endpoint locations from xml sitemapindex", new Object[0]));
        return Utils.collectAsStrings(this.contentFile, "/urlset/url/loc/text()");
    }

    @Override
    public boolean hasNext() {
        return !this.locations.isEmpty();
    }

    @Override
    public String next() {
        return this.locations.poll();
    }

    public static class Options {
        private SitemapFileType fileType;
        private SitemapSchemaType schemaType;
        private URL fileUrl;
        private Charset charset;

        public Options() {
        }

        public Options(URL fileUrl, Charset charset, SitemapSchemaType schemaType, SitemapFileType fileType) {
            this.fileUrl = fileUrl;
            this.charset = charset;
            this.schemaType = schemaType;
            this.fileType = fileType;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        public URL getFileUrl() {
            return this.fileUrl;
        }

        public void setFileUrl(URL fileUrl) {
            this.fileUrl = fileUrl;
        }

        public SitemapFileType getFileType() {
            return this.fileType;
        }

        public void setFileType(SitemapFileType fileType) {
            this.fileType = fileType;
        }

        public SitemapSchemaType getSchemaType() {
            return this.schemaType;
        }

        public void setSchemaType(SitemapSchemaType schemaType) {
            this.schemaType = schemaType;
        }

        public Object clone() {
            Options clone = new Options();
            clone.setCharset(this.getCharset());
            clone.setFileType(this.getFileType());
            clone.setFileUrl(this.getFileUrl());
            clone.setSchemaType(this.getSchemaType());
            return clone;
        }

        public static enum SitemapSchemaType {
            Text,
            Xml;

        }

        public static enum SitemapFileType {
            Text,
            GZ;

        }
    }
}

