/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.schemaorg.sitemapindex;

import eu.dnetlib.data.collector.plugins.schemaorg.Utils;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SitemapIndexIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(SitemapIndexIterator.class);
    private Options options;
    private Queue<String> sitemapFiles;

    public SitemapIndexIterator(Options options) {
        this.options = options;
    }

    public void bootstrap() {
        List<Object> files = null;
        try {
            log.debug((Object)"bootstrapping sitemapindex index access");
            String sitemapIndexPayload = IOUtils.toString((URL)this.options.getIndexUrl(), (Charset)this.options.getCharset());
            log.debug((Object)String.format("sitemapindex payload is: %s", sitemapIndexPayload));
            files = Utils.collectAsStrings(sitemapIndexPayload, "/sitemapindex/sitemap/loc/text()");
            log.debug((Object)String.format("extracted %d sitemapindex files", files.size()));
        }
        catch (Exception ex) {
            log.error((Object)"problem bootstrapping sitemapindex index access. returning 0 files", (Throwable)ex);
            files = new ArrayList();
        }
        this.sitemapFiles = new PriorityQueue<String>(files);
    }

    @Override
    public boolean hasNext() {
        return !this.sitemapFiles.isEmpty();
    }

    @Override
    public String next() {
        return this.sitemapFiles.poll();
    }

    public static class Options {
        private URL indexUrl;
        private Charset charset;

        public Options() {
        }

        public Options(URL indexUrl, Charset charset) {
            this.indexUrl = indexUrl;
            this.charset = charset;
        }

        public URL getIndexUrl() {
            return this.indexUrl;
        }

        public void setIndexUrl(URL indexUrl) {
            this.indexUrl = indexUrl;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }
    }
}

