/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.datasets;

import eu.dnetlib.data.collector.plugins.datasets.DatasetsByProjectIterator;
import eu.dnetlib.data.collector.plugins.datasets.DatasetsIterator;
import eu.dnetlib.data.collector.plugins.datasets.PangaeaJournalInfo;
import eu.dnetlib.data.collector.plugins.datasets.QueryField;
import eu.dnetlib.data.collector.plugins.datasets.RequestField;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatasetsByJournalIterator
implements Iterable<String>,
Iterator<String> {
    private Iterator<String> currentIterator;
    private PangaeaJournalInfo currentJournal;
    private Iterator<PangaeaJournalInfo> inputIterator;
    private static final Log log = LogFactory.getLog(DatasetsByProjectIterator.class);

    public DatasetsByJournalIterator(Iterator<PangaeaJournalInfo> iterator) {
        this.inputIterator = iterator;
        this.currentJournal = this.extractNextLine();
    }

    @Override
    public boolean hasNext() {
        if (this.currentJournal == null) {
            return false;
        }
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            return true;
        }
        this.currentJournal = this.extractNextLine();
        while (this.currentJournal != null) {
            this.currentIterator = this.getNextIterator();
            if (this.currentIterator.hasNext()) {
                return true;
            }
            this.currentJournal = this.extractNextLine();
        }
        return false;
    }

    @Override
    public String next() {
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
    }

    @Override
    public Iterator<String> iterator() {
        if (this.currentJournal != null) {
            this.currentIterator = this.getNextIterator();
            return this;
        }
        return null;
    }

    private Iterator<String> getNextIterator() {
        QueryField q = new QueryField();
        RequestField r = new RequestField();
        r.setQuery(q);
        q.getTerm().put("ft-techkeyword", this.currentJournal.getJournalId());
        return new DatasetsIterator(r, "", this.currentJournal).iterator();
    }

    private PangaeaJournalInfo extractNextLine() {
        if (!this.inputIterator.hasNext()) {
            return null;
        }
        return this.inputIterator.next();
    }
}

