/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.schemaorg;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONLDUtils {
    private static PlaceInfo extractPlaceSingle(JSONObject document) {
        if (document == null || !"Place".equals(document.optString("@type"))) {
            return null;
        }
        String name = document.optString("name");
        List<GeoCoordinatesInfo> geoCoordinates = JSONLDUtils.extractGeoCoordinates(document, "geo");
        List<GeoShapeInfo> geoShapes = JSONLDUtils.extractGeoShapes(document, "geo");
        if (!(name != null && name.trim().length() != 0 || geoCoordinates != null && geoCoordinates.size() != 0 || geoShapes != null && geoShapes.size() != 0)) {
            return null;
        }
        return new PlaceInfo(name, geoCoordinates, geoShapes);
    }

    public static List<PlaceInfo> extractPlaces(JSONObject document, String key) {
        PlaceInfo nfo;
        ArrayList<PlaceInfo> items = new ArrayList<PlaceInfo>();
        JSONArray array = document.optJSONArray(key);
        JSONObject obj = document.optJSONObject(key);
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                PlaceInfo nfo2 = JSONLDUtils.extractPlaceSingle(array.optJSONObject(i));
                if (nfo2 == null) continue;
                items.add(nfo2);
            }
        } else if (obj != null && (nfo = JSONLDUtils.extractPlaceSingle(obj)) != null) {
            items.add(nfo);
        }
        return items;
    }

    private static GeoCoordinatesInfo extractGeoCoordinatesSingle(JSONObject document) {
        if (document == null || !"GeoCoordinates".equals(document.optString("@type"))) {
            return null;
        }
        String latitude = document.optString("latitude");
        String longitude = document.optString("longitude");
        if (latitude == null || latitude.trim().length() == 0 || longitude == null || longitude.trim().length() == 0) {
            return null;
        }
        return new GeoCoordinatesInfo(latitude, longitude);
    }

    private static List<GeoCoordinatesInfo> extractGeoCoordinates(JSONObject document, String key) {
        GeoCoordinatesInfo nfo;
        ArrayList<GeoCoordinatesInfo> items = new ArrayList<GeoCoordinatesInfo>();
        JSONArray array = document.optJSONArray(key);
        JSONObject obj = document.optJSONObject(key);
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                GeoCoordinatesInfo nfo2 = JSONLDUtils.extractGeoCoordinatesSingle(array.optJSONObject(i));
                if (nfo2 == null) continue;
                items.add(nfo2);
            }
        } else if (obj != null && (nfo = JSONLDUtils.extractGeoCoordinatesSingle(obj)) != null) {
            items.add(nfo);
        }
        return items;
    }

    private static GeoShapeInfo extractGeoShapeSingle(JSONObject document) {
        if (document == null || !"GeoShape".equals(document.optString("@type"))) {
            return null;
        }
        String box = document.optString("box");
        if (box == null || box.trim().length() == 0) {
            return null;
        }
        return new GeoShapeInfo(box);
    }

    private static List<GeoShapeInfo> extractGeoShapes(JSONObject document, String key) {
        GeoShapeInfo nfo;
        ArrayList<GeoShapeInfo> items = new ArrayList<GeoShapeInfo>();
        JSONArray array = document.optJSONArray(key);
        JSONObject obj = document.optJSONObject(key);
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                GeoShapeInfo nfo2 = JSONLDUtils.extractGeoShapeSingle(array.optJSONObject(i));
                if (nfo2 == null) continue;
                items.add(nfo2);
            }
        } else if (obj != null && (nfo = JSONLDUtils.extractGeoShapeSingle(obj)) != null) {
            items.add(nfo);
        }
        return items;
    }

    private static OrganizationInfo extractOrganizationSingle(JSONObject document) {
        if (document == null || !"Organization".equals(document.optString("@type"))) {
            return null;
        }
        String name = document.optString("name");
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        return new OrganizationInfo(name);
    }

    private static List<OrganizationInfo> extractOrganization(JSONObject document, String key) {
        OrganizationInfo nfo;
        ArrayList<OrganizationInfo> items = new ArrayList<OrganizationInfo>();
        JSONArray array = document.optJSONArray(key);
        JSONObject obj = document.optJSONObject(key);
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                OrganizationInfo nfo2 = JSONLDUtils.extractOrganizationSingle(array.optJSONObject(i));
                if (nfo2 == null) continue;
                items.add(nfo2);
            }
        } else if (obj != null && (nfo = JSONLDUtils.extractOrganizationSingle(obj)) != null) {
            items.add(nfo);
        }
        return items;
    }

    private static PersonInfo extractPersonSingle(JSONObject document) {
        if (document == null || !"Person".equals(document.optString("@type"))) {
            return null;
        }
        String name = document.optString("name");
        String givenName = document.optString("givenName");
        String familyName = document.optString("familyName");
        if (!(name != null && name.trim().length() != 0 || givenName == null && familyName == null)) {
            if (givenName != null && familyName != null) {
                name = String.join((CharSequence)" ", familyName, givenName).trim();
            } else if (givenName == null) {
                name = familyName;
            } else if (familyName == null) {
                name = givenName;
            }
        }
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        List<OrganizationInfo> affiliations = JSONLDUtils.extractOrganization(document, "affiliation");
        return new PersonInfo(name, affiliations);
    }

    private static List<PersonInfo> extractPerson(JSONObject document, String key) {
        ArrayList<PersonInfo> items = new ArrayList<PersonInfo>();
        JSONArray array = document.optJSONArray(key);
        JSONObject obj = document.optJSONObject(key);
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                PersonInfo nfo = JSONLDUtils.extractPersonSingle(array.optJSONObject(i));
                if (nfo == null) continue;
                items.add(nfo);
            }
        } else if (obj != null) {
            PersonInfo nfo = JSONLDUtils.extractPersonSingle(obj);
            if (nfo != null) {
                items.add(nfo);
            }
        } else {
            String value = document.optString(key);
            if (value != null) {
                items.add(new PersonInfo(value));
            }
        }
        return items;
    }

    public static PrincipalInfo extractPrincipalSingle(JSONObject document) {
        PrincipalInfo principal = JSONLDUtils.extractPersonSingle(document);
        if (principal == null) {
            principal = JSONLDUtils.extractOrganizationSingle(document);
        }
        return principal;
    }

    public static List<PrincipalInfo> extractPrincipal(JSONObject document, String key) {
        ArrayList<PrincipalInfo> items = new ArrayList<PrincipalInfo>();
        JSONArray array = document.optJSONArray(key);
        JSONObject obj = document.optJSONObject(key);
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                PrincipalInfo nfo = JSONLDUtils.extractPrincipalSingle(array.optJSONObject(i));
                if (nfo == null) continue;
                items.add(nfo);
            }
        } else if (obj != null) {
            PrincipalInfo nfo = JSONLDUtils.extractPrincipalSingle(obj);
            if (nfo != null) {
                items.add(nfo);
            }
        } else {
            String value = document.optString(key);
            if (value != null) {
                items.add(new PersonInfo(value));
            }
        }
        return items;
    }

    public static List<String> extractString(JSONObject document, String key) {
        String value;
        ArrayList<String> items = new ArrayList<String>();
        if (!document.has(key)) {
            return items;
        }
        JSONArray array = document.optJSONArray(key);
        JSONObject obj = document.optJSONObject(key);
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                String value2;
                JSONObject item = array.optJSONObject(i);
                if (item != null || (value2 = array.optString(i)) == null) continue;
                items.add(value2);
            }
        } else if (obj == null && (value = document.optString(key)) != null) {
            items.add(value);
        }
        return items;
    }

    public static List<String> extractSize(JSONObject document, String key) {
        ArrayList<String> items = new ArrayList<String>();
        JSONArray array = document.optJSONArray(key);
        JSONObject obj = document.optJSONObject(key);
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                String size;
                JSONObject item = array.optJSONObject(i);
                if (item == null || !"DataDownload".equals(item.optString("@type")) || (size = item.optString("contentSize")) == null) continue;
                items.add(size);
            }
        } else if (obj != null) {
            String size = obj.optString("contentSize");
            if ("DataDownload".equals(obj.optString("@type")) && size != null) {
                items.add(size);
            }
        }
        return items;
    }

    public static List<String> extractEncodingFormat(JSONObject document, String key) {
        ArrayList<String> items = new ArrayList<String>();
        JSONArray array = document.optJSONArray(key);
        JSONObject obj = document.optJSONObject(key);
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                String fileFormat;
                JSONObject item = array.optJSONObject(i);
                if (item == null || !"DataDownload".equals(item.optString("@type"))) continue;
                String encodingFormat = item.optString("encodingFormat");
                if (encodingFormat != null) {
                    items.add(encodingFormat);
                }
                if ((fileFormat = item.optString("fileFormat")) == null) continue;
                items.add(fileFormat);
            }
        } else if (obj != null && "DataDownload".equals(obj.optString("@type"))) {
            String fileFormat;
            String encodingFormat = obj.optString("encodingFormat");
            if (encodingFormat != null) {
                items.add(encodingFormat);
            }
            if ((fileFormat = obj.optString("fileFormat")) != null) {
                items.add(fileFormat);
            }
        }
        return items;
    }

    public static List<String> extractLanguage(JSONObject document, String key) {
        ArrayList<String> items = new ArrayList<String>();
        JSONArray array = document.optJSONArray(key);
        JSONObject obj = document.optJSONObject(key);
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                String alternateName;
                JSONObject item = array.optJSONObject(i);
                if (item == null) {
                    String value = array.optString(i);
                    if (value == null) continue;
                    items.add(value);
                    continue;
                }
                if (!"Language".equals(item.optString("@type"))) continue;
                String name = item.optString("name");
                if (name != null) {
                    items.add(name);
                }
                if ((alternateName = item.optString("alternateName")) == null) continue;
                items.add(alternateName);
            }
        } else if (obj != null) {
            if ("Language".equals(obj.optString("@type"))) {
                String alternateName;
                String name = obj.optString("name");
                if (name != null) {
                    items.add(name);
                }
                if ((alternateName = obj.optString("alternateName")) != null) {
                    items.add(alternateName);
                }
            }
        } else {
            String value = document.optString(key);
            if (value != null) {
                items.add(value);
            }
        }
        return items;
    }

    public static List<LicenseInfo> extractLicenses(JSONObject document, String key) {
        ArrayList<LicenseInfo> items = new ArrayList<LicenseInfo>();
        JSONArray array = document.optJSONArray(key);
        JSONObject obj = document.optJSONObject(key);
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                JSONObject item = array.optJSONObject(i);
                if (item == null) {
                    String value = array.optString(i);
                    if (value == null) continue;
                    items.add(new LicenseInfo(value));
                    continue;
                }
                if (!"CreativeWork".equals(item.optString("@type"))) continue;
                String url = item.optString("url");
                String name = item.optString("name");
                if (url == null && name == null) continue;
                items.add(new LicenseInfo(url, name));
            }
        } else if (obj != null) {
            if ("CreativeWork".equals(obj.optString("@type"))) {
                String url = obj.optString("url");
                String name = obj.optString("name");
                if (url != null || name != null) {
                    items.add(new LicenseInfo(url, name));
                }
            }
        } else {
            String value = document.optString(key);
            if (value != null) {
                items.add(new LicenseInfo(value));
            }
        }
        return items;
    }

    public static List<CitationInfo> extractCitations(JSONObject document, String key) {
        ArrayList<CitationInfo> items = new ArrayList<CitationInfo>();
        JSONArray array = document.optJSONArray(key);
        JSONObject obj = document.optJSONObject(key);
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                String url;
                JSONObject item = array.optJSONObject(i);
                if (item == null) {
                    String value = array.optString(i);
                    if (value == null) continue;
                    items.add(new CitationInfo(value));
                    continue;
                }
                if (!"CreativeWork".equals(item.optString("@type")) || (url = item.optString("url")) == null) continue;
                items.add(new CitationInfo(url));
            }
        } else if (obj != null) {
            String url;
            if ("CreativeWork".equals(obj.optString("@type")) && (url = obj.optString("url")) != null) {
                items.add(new CitationInfo(url));
            }
        } else {
            String value = document.optString(key);
            if (value != null) {
                items.add(new CitationInfo(value));
            }
        }
        return items;
    }

    private static IdentifierInfo extractIdentifierSingle(JSONObject document) {
        if (document == null || !"PropertyValue".equals(document.optString("@type"))) {
            return null;
        }
        String name = document.optString("name");
        String value = document.optString("value");
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return new IdentifierInfo(value, name);
    }

    public static List<IdentifierInfo> extractIdentifier(JSONObject document, String key) {
        ArrayList<IdentifierInfo> items = new ArrayList<IdentifierInfo>();
        JSONArray array = document.optJSONArray(key);
        JSONObject obj = document.optJSONObject(key);
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                String value;
                IdentifierInfo nfo = null;
                if (array.optJSONObject(i) == null && (value = array.optString(i)) != null) {
                    nfo = new IdentifierInfo(value);
                }
                if (nfo == null) {
                    nfo = JSONLDUtils.extractIdentifierSingle(array.optJSONObject(i));
                }
                if (nfo == null) continue;
                items.add(nfo);
            }
        } else if (obj != null) {
            IdentifierInfo nfo = JSONLDUtils.extractIdentifierSingle(obj);
            if (nfo != null) {
                items.add(nfo);
            }
        } else {
            String value = document.optString(key);
            if (value != null) {
                items.add(new IdentifierInfo(value));
            }
        }
        return items;
    }

    public static class PlaceInfo {
        public String name;
        public List<GeoCoordinatesInfo> geoCoordinates;
        public List<GeoShapeInfo> geoShapes;

        public PlaceInfo() {
        }

        public PlaceInfo(String name, List<GeoCoordinatesInfo> geoCoordinates, List<GeoShapeInfo> geoShapes) {
            this.name = name;
            this.geoCoordinates = geoCoordinates;
            this.geoShapes = geoShapes;
        }
    }

    public static class GeoShapeInfo {
        public String box;

        public GeoShapeInfo() {
        }

        public GeoShapeInfo(String box) {
            this.box = box;
        }
    }

    public static class GeoCoordinatesInfo {
        public String latitude;
        public String longitude;

        public GeoCoordinatesInfo() {
        }

        public GeoCoordinatesInfo(String latitude, String longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }
    }

    public static class IdentifierInfo {
        public String value;
        public String type;

        public IdentifierInfo() {
        }

        public IdentifierInfo(String value) {
            this.value = value;
        }

        public IdentifierInfo(String value, String type) {
            this.value = value;
            this.type = type;
        }
    }

    public static class CitationInfo {
        public String url;

        public CitationInfo() {
        }

        public CitationInfo(String url) {
            this.url = url;
        }
    }

    public static class LicenseInfo {
        public String name;
        public String url;

        public LicenseInfo() {
        }

        public LicenseInfo(String url) {
            this.url = url;
        }

        public LicenseInfo(String url, String name) {
            this.name = name;
            this.url = url;
        }
    }

    public static class PersonInfo
    implements PrincipalInfo {
        public String name;
        public List<OrganizationInfo> affiliations;

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public List<String> affiliationNames() {
            if (this.affiliations == null) {
                return null;
            }
            ArrayList<String> curated = new ArrayList<String>();
            for (OrganizationInfo item : this.affiliations) {
                if (item == null || item.name == null || item.name.trim().length() == 0) continue;
                curated.add(item.name.trim());
            }
            return curated;
        }

        public PersonInfo() {
        }

        public PersonInfo(String name) {
            this.name = name;
        }

        public PersonInfo(String name, List<OrganizationInfo> affiliations) {
            this.name = name;
            this.affiliations = affiliations;
        }
    }

    public static class OrganizationInfo
    implements PrincipalInfo {
        public String name;

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public List<String> affiliationNames() {
            return null;
        }

        public OrganizationInfo() {
        }

        public OrganizationInfo(String name) {
            this.name = name;
        }
    }

    public static interface PrincipalInfo {
        public String name();

        public List<String> affiliationNames();
    }
}

