/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.schemaorg;

import eu.dnetlib.data.collector.plugins.schemaorg.DatasetMappingIterator;
import eu.dnetlib.data.collector.plugins.schemaorg.EndpointAccessIterator;
import eu.dnetlib.data.collector.plugins.schemaorg.RepositoryIterable;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SchemaOrgIterable
implements Iterable<String> {
    private static final Log log = LogFactory.getLog(SchemaOrgIterable.class);
    private Options options;
    private RepositoryIterable repository;

    public SchemaOrgIterable(Options options, RepositoryIterable repository) {
        this.options = options;
        this.repository = repository;
    }

    @Override
    public Iterator<String> iterator() {
        Iterator<String> repositoryIterator = this.repository.iterator();
        EndpointAccessIterator endpointAccessIterator = new EndpointAccessIterator(this.options.getEndpointAccessOptions(), repositoryIterator);
        DatasetMappingIterator datasetMappingIterator = new DatasetMappingIterator(this.options.getDatasetMappingOptions(), endpointAccessIterator);
        return datasetMappingIterator;
    }

    public static class Options {
        private EndpointAccessIterator.Options endpointAccessOptions;
        private DatasetMappingIterator.Options datasetMappingOptions;

        public EndpointAccessIterator.Options getEndpointAccessOptions() {
            return this.endpointAccessOptions;
        }

        public void setEndpointAccessOptions(EndpointAccessIterator.Options endpointAccessOptions) {
            this.endpointAccessOptions = endpointAccessOptions;
        }

        public DatasetMappingIterator.Options getDatasetMappingOptions() {
            return this.datasetMappingOptions;
        }

        public void setDatasetMappingOptions(DatasetMappingIterator.Options datasetMappingOptions) {
            this.datasetMappingOptions = datasetMappingOptions;
        }
    }
}

